/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.actions;

import io.emmet.Emmet;
import io.emmet.actions.AbstractMenuItem;
import io.emmet.actions.Action;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Menu
extends AbstractMenuItem {
    private String type = "menu";
    private String name = null;
    private ArrayList<AbstractMenuItem> items;

    public static Menu create() {
        Emmet jse = Emmet.getSingleton();
        Object actions = jse.execJSFunction("require('actions').getMenu", new Object[0]);
        return new Menu("Emmet", Menu.itemsFromJSArray((NativeArray)actions));
    }

    private static ArrayList<AbstractMenuItem> itemsFromJSArray(NativeArray ar) {
        ArrayList<AbstractMenuItem> list = new ArrayList<AbstractMenuItem>();
        int i = 0;
        while ((long)i < ar.getLength()) {
            NativeObject menuItem = (NativeObject)ScriptableObject.getProperty((Scriptable)ar, (int)i);
            if (Context.toString((Object)ScriptableObject.getProperty((Scriptable)menuItem, (String)"type")).equals("action")) {
                list.add(new Action(menuItem));
            } else {
                list.add(new Menu(menuItem));
            }
            ++i;
        }
        return list;
    }

    public Menu(String name, ArrayList<AbstractMenuItem> items) {
        this.name = name;
        this.items = items;
    }

    public Menu(NativeObject item) {
        this.name = Context.toString((Object)ScriptableObject.getProperty((Scriptable)item, (String)"name"));
        this.items = Menu.itemsFromJSArray((NativeArray)ScriptableObject.getProperty((Scriptable)item, (String)"items"));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ArrayList<AbstractMenuItem> getItems() {
        return this.items;
    }
}

