/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.rest.ui.action;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragment;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.AbstractDropAction;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.IModelProvider;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.editor.SelectionConvertor;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ConfigurationPointCalculator;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.NullSourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.tizen.common.rest.model.run.RequestModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.util.OutputUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.web.editor.html.HTMLEditor;
import org.tizen.web.editor.javascript.JavaScriptEditor;
import org.tizen.web.rest.RestWebPlugin;
import org.tizen.web.rest.template.IDocumentConstants;
import org.tizen.web.rest.template.ITemplateConstants;
import org.tizen.web.rest.template.TemplateManager;
import org.tizen.web.rest.ui.dialogs.RestFunctionSelectionDialog;
import org.tizen.web.rest.ui.model.RestAPIModel;
import org.tizen.web.rest.util.NamingUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RestModelDropAction
extends AbstractDropAction
implements IDocumentConstants {
    private IPath restPath = null;

    public boolean run(DropTargetEvent event, IEditorPart targetEditor) {
        if (targetEditor instanceof HTMLEditor || targetEditor instanceof JavaScriptEditor) {
            TreePath path;
            Object obj;
            List<RestAPIModel> list;
            IFileEditorInput input = (IFileEditorInput)targetEditor.getEditorInput();
            IProject project = input.getFile().getProject();
            try {
                list = this.getFunctionList(project);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
            ITreeSelection selection = (ITreeSelection)event.data;
            if (selection.size() == 1 && (obj = (path = selection.getPaths()[0]).getLastSegment()) instanceof Method) {
                RestFunctionSelectionDialog dialog;
                RestFunctionSelectionDialog.FunctionSelectResult result;
                Method m = (Method)obj;
                DialogInitialData data = this.generateDialogInitialData(targetEditor);
                Node node = null;
                String defaultEventName = "";
                String defaultCallName = "";
                if (data != null) {
                    node = data.getOwnerElement();
                    defaultEventName = data.getEventName();
                    defaultCallName = data.getCallName();
                }
                boolean eventNameEnabled = true;
                if (targetEditor instanceof JavaScriptEditor) {
                    eventNameEnabled = false;
                }
                if ((result = (RestFunctionSelectionDialog.FunctionSelectResult)(dialog = new RestFunctionSelectionDialog(event.display.getActiveShell(), path, list, node, defaultEventName, defaultCallName, eventNameEnabled)).open()) != null) {
                    String eventName = result.getEventName();
                    String callName = result.getCallName();
                    eventNameEnabled = result.isEventNameEnabled();
                    String functionTemplateKey = result.getTemplateKeyName();
                    RestAPIModel model = result.getSelectedModel();
                    Map<String, Object> map = this.generateData(m, model, callName, targetEditor);
                    return this.applyToEditor(targetEditor, map, functionTemplateKey, eventName, eventNameEnabled);
                }
            }
        }
        return false;
    }

    private boolean applyToEditor(IEditorPart targetEditor, Map<String, Object> map, String functionTemplateKey, String eventName, boolean eventNameEnabled) {
        boolean result = false;
        try {
            TemplateManager manager = TemplateManager.getInstance();
            String callName = manager.process("TEMPLATE_KEY_FUNCTION_CALL", map);
            result = this.handleSource(manager, eventName, eventNameEnabled, callName, functionTemplateKey, map, targetEditor);
        }
        catch (TemplateException e) {
            RestWebPlugin.log(e);
        }
        catch (IOException e) {
            RestWebPlugin.log(e);
        }
        catch (RuntimeException e) {
            RestWebPlugin.log(e);
        }
        catch (BadLocationException e) {
            RestWebPlugin.log(e);
        }
        return result;
    }

    protected boolean handleSource(TemplateManager templateManager, String eventName, boolean eventNameEnabled, String callName, String functionTemplateKey, Map<String, Object> map, IEditorPart editor) throws RuntimeException, IOException, TemplateException, BadLocationException {
        if (editor instanceof HTMLEditor) {
            HTMLEditor textEditor = (HTMLEditor)editor;
            ISourceEditingTextTools tools = (ISourceEditingTextTools)textEditor.getAdapter(ISourceEditingTextTools.class);
            if (tools == null) {
                throw new RuntimeException("");
            }
            IDocument doc = tools.getDocument();
            ITextSelection selection = tools.getSelection();
            if (selection instanceof ITextSelection) {
                SelectionConvertor selectionConvertor;
                Object[] elements;
                ITextSelection textSelection = selection;
                IModelManager manager = StructuredModelManager.getModelManager();
                IStructuredModel model = manager.getExistingModelForEdit(doc);
                if (model instanceof DOMModelImpl && (elements = (selectionConvertor = (SelectionConvertor)model.getAdapter(SelectionConvertor.class)).getElements(model, textSelection.getOffset(), textSelection.getOffset())).length == 1 && elements[0] instanceof NodeImpl) {
                    NodeImpl element = (NodeImpl)elements[0];
                    Document document = element.getOwnerDocument();
                    IFile editorSource = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
                    IFile destFile = this.copyRESTLib(editorSource);
                    IPath relativePath = destFile.getProjectRelativePath().makeRelativeTo(editorSource.getProjectRelativePath()).removeFirstSegments(1);
                    if (eventNameEnabled) {
                        this.handleEventAttr(element, eventName, callName);
                    }
                    ElementImpl scriptElement = this.handleScriptElement(document, relativePath, eventNameEnabled);
                    int offset = textSelection.getOffset();
                    if (eventNameEnabled) {
                        offset = scriptElement.getEndStartOffset();
                    }
                    StringBuffer buf = this.makeFunctionStrings(templateManager, functionTemplateKey, map);
                    doc.replace(offset, 0, buf.toString());
                    String callNameSignature = callName.substring(0, callName.length() - 3);
                    int functionNameStart = offset + buf.indexOf(callNameSignature);
                    if (eventNameEnabled) {
                        textEditor.selectAndReveal(functionNameStart, callNameSignature.length());
                    } else {
                        textEditor.selectAndReveal(offset, buf.length());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected IFile copyRESTLib(IFile editorSource) {
        IPath destPath;
        IProject project = editorSource.getProject();
        IFile destFile = project.getFile(destPath = project.getProjectRelativePath().append(String.valueOf(File.separatorChar) + "js" + File.separatorChar + "rest.js"));
        if (!destFile.exists() && this.restPath != null) {
            try {
                FileUtil.copyTo((String)this.restPath.toOSString(), (String)destFile.getLocation().toOSString());
                destFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                RestWebPlugin.log(e);
            }
            catch (CoreException e) {
                RestWebPlugin.log(e);
            }
        }
        return destFile;
    }

    private ElementImpl handleScriptElement(Document document, IPath restLibPath, boolean eventNameEnabled) {
        NodeList scriptTagList = document.getElementsByTagName("script");
        ElementImpl scriptElement = null;
        boolean restLibFound = false;
        if (scriptTagList.getLength() > 0) {
            int i = 0;
            while (i < scriptTagList.getLength()) {
                Node n = scriptTagList.item(i);
                if (this.findAttribute(n, "src") == null && this.findAttribute(n, "type").equalsIgnoreCase("text/javascript")) {
                    scriptElement = (ElementImpl)n;
                    break;
                }
                String srcAttr = this.findAttribute(n, "src");
                if (srcAttr != null && srcAttr.equals(restLibPath.toString())) {
                    restLibFound = true;
                }
                ++i;
            }
        }
        if (!restLibFound) {
            this.makeScriptSrcElement(document, restLibPath.toString());
        }
        if (scriptElement == null && eventNameEnabled) {
            scriptElement = (ElementImpl)this.makeScriptElement(document);
        }
        return scriptElement;
    }

    private void handleEventAttr(NodeImpl element, String eventName, String callName) {
        ElementImpl ownerElement = null;
        short nodeType = element.getNodeType();
        if (nodeType == 2 || nodeType == 3) {
            if (nodeType == 2) {
                AttrImpl attr = (AttrImpl)element;
                ownerElement = (ElementImpl)attr.getOwnerElement();
            } else {
                ownerElement = (ElementImpl)this.findParentElement((Node)element);
            }
        } else if (nodeType == 1) {
            ownerElement = (ElementImpl)element;
        }
        if (ownerElement != null) {
            AttrImpl eventAttr = (AttrImpl)ownerElement.getAttributeNode(eventName);
            if (eventAttr == null) {
                eventAttr = (AttrImpl)ownerElement.getOwnerDocument().createAttribute(eventName);
                ownerElement.setAttributeNode((Attr)eventAttr);
            }
            eventAttr.setValue(callName);
        }
    }

    protected StringBuffer makeFunctionStrings(TemplateManager templateManager, String functionTemplateKey, Map<String, Object> map) throws TemplateException, IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(ITemplateConstants.LINE_FEED);
        String functionStr = templateManager.process(functionTemplateKey, map);
        buf.append(functionStr);
        return buf;
    }

    private Element makeScriptElement(Document doc) {
        Node headNode = this.getHeadNode(doc);
        headNode.appendChild(doc.createTextNode(ITemplateConstants.LINE_FEED));
        Element element = doc.createElement("script");
        element.setAttribute("type", "text/javascript");
        headNode.appendChild(element);
        headNode.appendChild(doc.createTextNode(ITemplateConstants.LINE_FEED));
        return element;
    }

    private Element makeScriptSrcElement(Document doc, String src) {
        Node headNode = this.getHeadNode(doc);
        Element element = doc.createElement("script");
        element.setAttribute("src", src);
        headNode.appendChild(element);
        return element;
    }

    private Node getHeadNode(Document doc) {
        NodeList headList = doc.getElementsByTagName("head");
        Node headNode = null;
        headNode = headList.getLength() > 0 ? headList.item(0) : this.makeHeadElement(doc);
        return headNode;
    }

    private Element makeHeadElement(Document doc) {
        Node htmlNode = doc.getElementsByTagName("html").item(0);
        Element element = doc.createElement("head");
        htmlNode.appendChild(element);
        return element;
    }

    private Map<String, Object> generateData(Method m, RestAPIModel result, String callName, IEditorPart targetEditor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RequestModel reqModel = new RequestModel(m);
        String apiName = result.getElementName();
        map.put("apiName", "rest." + apiName);
        String url = reqModel.getRequestUrl();
        map.put("url", url);
        List paramList = reqModel.getParamList();
        String paramJson = "null";
        if (paramList != null && paramList.size() > 0) {
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            for (NameValuePair p : paramList) {
                paramMap.put(p.getName(), p.getValue());
            }
            paramJson = OutputUtil.toJson(paramMap);
        }
        map.put("data", paramJson);
        Map headerMap = reqModel.getHeaderMap();
        String headerJson = "null";
        if (headerMap != null && headerMap.size() > 0) {
            headerJson = OutputUtil.toJson((Object)headerMap);
        }
        map.put("header", headerJson);
        map.put("functionName", callName);
        return map;
    }

    private DialogInitialData generateDialogInitialData(IEditorPart editor) {
        SelectionConvertor selectionConvertor;
        Object[] elements;
        ISourceEditingTextTools tools = (ISourceEditingTextTools)editor.getAdapter(ISourceEditingTextTools.class);
        if (tools == null && editor instanceof ITextEditor) {
            tools = this.createSourceEditingTextTools((ITextEditor)editor);
        }
        if (tools == null) {
            return null;
        }
        IDocument doc = tools.getDocument();
        ITextSelection textSelection = tools.getSelection();
        IModelManager manager = StructuredModelManager.getModelManager();
        IStructuredModel model = manager.getExistingModelForEdit(doc);
        if (model instanceof DOMModelImpl && (elements = (selectionConvertor = (SelectionConvertor)model.getAdapter(SelectionConvertor.class)).getElements(model, textSelection.getOffset(), textSelection.getOffset())).length == 1 && elements[0] instanceof NodeImpl) {
            NodeImpl element;
            String id = "";
            String tagName = "";
            String eventName = "";
            String attrName = null;
            NodeImpl ownerElement = element = (NodeImpl)elements[0];
            short nodeType = element.getNodeType();
            if (nodeType == 2 || nodeType == 3) {
                Node parent = null;
                if (nodeType == 2) {
                    AttrImpl attr = (AttrImpl)element;
                    attrName = attr.getName();
                    parent = attr.getOwnerElement();
                    if (attrName.toLowerCase().startsWith("on")) {
                        eventName = attrName;
                    }
                } else {
                    parent = this.findParentElement((Node)element);
                }
                ownerElement = (NodeImpl)parent;
                tagName = parent.getNodeName();
                id = this.findAttribute(parent, "id");
            } else if (nodeType == 1) {
                tagName = element.getNodeName();
                id = this.findAttribute((Node)element, "id");
            }
            String callName = NamingUtil.generateFunctionName(id, tagName, attrName);
            return new DialogInitialData((Node)ownerElement, eventName, callName);
        }
        return null;
    }

    private String findAttribute(Node node, String attrName) {
        Node found;
        NamedNodeMap map = node.getAttributes();
        if (map != null && (found = map.getNamedItem(attrName)) != null) {
            return found.getNodeValue();
        }
        return null;
    }

    private Node findParentElement(Node node) {
        Node parent = node.getParentNode();
        if (parent.getNodeType() == 1) {
            return parent;
        }
        return this.findParentElement(parent);
    }

    private List<RestAPIModel> getFunctionList(IProject project) throws JavaScriptModelException {
        IJavaScriptProject[] javaScriptProjects;
        ArrayList<RestAPIModel> list = new ArrayList<RestAPIModel>();
        IJavaScriptProject[] iJavaScriptProjectArray = javaScriptProjects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaScriptProjects();
        int n = javaScriptProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaScriptProject javaScriptProject = iJavaScriptProjectArray[n2];
            JavaProject jProject = (JavaProject)javaScriptProject;
            IProject currentProject = jProject.getProject();
            if (project.equals((Object)currentProject)) {
                IPackageFragment[] packageFragments;
                IPackageFragment[] iPackageFragmentArray = packageFragments = jProject.getPackageFragments();
                int n3 = packageFragments.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPackageFragment packageFragment = iPackageFragmentArray[n4];
                    if (packageFragment instanceof LibraryPackageFragment) {
                        IClassFile[] classFiles;
                        IClassFile[] iClassFileArray = classFiles = packageFragment.getClassFiles();
                        int n5 = classFiles.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IClassFile classFile = iClassFileArray[n6];
                            IPath path = classFile.getPath();
                            if (path.toOSString().contains("rest.js")) {
                                IType[] types;
                                this.restPath = path;
                                IType[] iTypeArray = types = classFile.getTypes();
                                int n7 = types.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IType type = iTypeArray[n8];
                                    if (FileUtil.getFileNameWithoutExtension((String)"rest.js").equalsIgnoreCase(type.getDisplayName())) {
                                        IFunction[] functions;
                                        IFunction[] iFunctionArray = functions = type.getFunctions();
                                        int n9 = functions.length;
                                        int n10 = 0;
                                        while (n10 < n9) {
                                            IFunction function = iFunctionArray[n10];
                                            list.add(new RestAPIModel(function.getDisplayName(), function.getParameterNames()));
                                            ++n10;
                                        }
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return list;
    }

    protected ISourceEditingTextTools createSourceEditingTextTools(ITextEditor editor) {
        ISourceEditingTextTools tools = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getIds(editor);
        int i = 0;
        while (tools == null && i < ids.length) {
            tools = (ISourceEditingTextTools)builder.getConfiguration("sourceeditingtexttools", ids[i]);
            ++i;
        }
        if (tools == null) {
            tools = NullSourceEditingTextTools.getInstance();
            ((NullSourceEditingTextTools)tools).setTextEditor(editor);
        }
        AccessibleObject method = null;
        try {
            method = tools.getClass().getMethod("setTextEditor", StructuredTextEditor.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (method == null) {
            try {
                method = tools.getClass().getMethod("setTextEditor", ITextEditor.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method == null) {
            try {
                method = tools.getClass().getMethod("setTextEditor", IEditorPart.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method != null) {
            if (!method.isAccessible()) {
                ((java.lang.reflect.Method)method).setAccessible(true);
            }
            try {
                ((java.lang.reflect.Method)method).invoke(tools, editor);
            }
            catch (Exception e) {
                Logger.logException((String)"Problem creating ISourceEditingTextTools implementation", (Throwable)e);
            }
        }
        return tools;
    }

    protected String[] getIds(ITextEditor editor) {
        IDocumentProvider provider;
        if (editor instanceof StructuredTextEditor && (provider = ((StructuredTextEditor)editor).getDocumentProvider()) instanceof IModelProvider) {
            IStructuredModel model = ((IModelProvider)provider).getModel((Object)editor.getEditorInput());
            return ConfigurationPointCalculator.getConfigurationPoints((IEditorPart)editor, (String)model.getContentTypeIdentifier(), (String)".source", StructuredTextEditor.class);
        }
        return new String[0];
    }

    private class DialogInitialData {
        private String eventName;
        private String callName;
        private Node ownerElement;

        private DialogInitialData(Node ownerElement, String eventName, String callName) {
            this.ownerElement = ownerElement;
            this.eventName = eventName;
            this.callName = callName;
        }

        public Node getOwnerElement() {
            return this.ownerElement;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getCallName() {
            return this.callName;
        }
    }
}

