/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.wizards;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.unittest.nls.NLSString;

public class MethodTreeViewer
extends CheckboxTreeViewer {
    private static final Logger logger = LoggerFactory.getLogger(MethodTreeViewer.class);

    public MethodTreeViewer(Composite parent) {
        super(parent, 2048);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean isCheckEvent = event.getChecked();
                MethodTreeViewer.this.setSubtreeChecked(element, isCheckEvent);
                if (!(element instanceof IFunction)) {
                    return;
                }
                IFunction function = (IFunction)element;
                if (!(function.getParent() instanceof IType)) {
                    return;
                }
                try {
                    IType type = (IType)function.getParent();
                    if (isCheckEvent) {
                        IFunction[] iFunctionArray = type.getFunctions();
                        int n = iFunctionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFunction func = iFunctionArray[n2];
                            if (!MethodTreeViewer.this.getChecked(func)) {
                                return;
                            }
                            ++n2;
                        }
                    }
                    MethodTreeViewer.this.setChecked(type, isCheckEvent);
                }
                catch (JavaScriptModelException e) {
                    logger.error(NLSString.MSG_FAIL_TO_GET_JS_FUNCTION, (Throwable)e);
                }
            }
        });
    }
}

