/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.config.schema.model.Feature;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TizenFeatureReader {
    public static final String FEATURE_DIR = "features";
    private static final String FEATURE_FILE_NAME_FILTER = "feature-.*\\.properties";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Collection<Feature> features;

    public Collection<Feature> getFeatures() {
        return this.features;
    }

    public TizenFeatureReader(IProject project) {
        TizenProjectDescription tizenDesc;
        if (this.features == null) {
            this.features = new HashSet<Feature>();
        }
        if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)(tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)project)))) {
            return;
        }
        ProfileInfo platformInfo = InstallPathConfig.getProfileInfo((String)tizenDesc.getProfileName());
        String featureDir = FileUtil.appendPath((String)platformInfo.getPlatformPath(tizenDesc.getVersion()), (String)FEATURE_DIR);
        this.features.addAll(this.getFeatures(featureDir, FEATURE_FILE_NAME_FILTER));
        if (platformInfo.isProduct(tizenDesc.getVersion())) {
            String parentProfileName = platformInfo.getParentProfileName(tizenDesc.getVersion());
            String parentPlatformPath = InstallPathConfig.getProfileInfo((String)parentProfileName).getPlatformPath(tizenDesc.getVersion());
            String parentPrivilegeDirPath = FileUtil.appendPath((String)parentPlatformPath, (String)FEATURE_DIR);
            this.features.addAll(this.getFeatures(parentPrivilegeDirPath, FEATURE_FILE_NAME_FILTER));
        }
    }

    private Collection<Feature> getFeatures(String featureDir, final String featureFileNameFilter) {
        HashSet<Feature> features = new HashSet<Feature>();
        File dir = new File(featureDir);
        if (!dir.exists()) {
            return features;
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(featureFileNameFilter);
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    File file = fileArray[n2];
                    FileInputStream fis = null;
                    try {
                        try {
                            fis = new FileInputStream(file);
                            features.addAll(this.readFeatureFromProperties(fis));
                        }
                        catch (FileNotFoundException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            IOUtil.tryClose((Object[])new Object[]{fis});
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{fis});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{fis});
                }
                ++n2;
            }
        }
        return features;
    }

    protected Collection<Feature> readFeatureFromProperties(InputStream in) {
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        reader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Document document = null;
        LinkedList<Feature> features = new LinkedList<Feature>();
        try {
            document = reader.read(in);
            Element propertiesElement = document.getRootElement();
            List entryElements = propertiesElement.elements("entry");
            for (Element entryElement : entryElements) {
                String name = entryElement.attributeValue("key");
                if (StringUtil.isEmpty((CharSequence)name)) continue;
                Feature feature = new Feature();
                feature.setName(name);
                features.add(feature);
            }
        }
        catch (DocumentException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return features;
    }
}

