/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.ui.wizards.online.TizenWizardFileServiceImpl;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;

public class TemplateCopyNewOperation
extends AbstractProjectTemplateOperation {
    public TemplateCopyNewOperation() {
        this.setMainTask(WizardMessages.NewWizardCopyTemplateOperationTask);
    }

    @Override
    public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        UserLogger.start((String)"web.wizard", (String)"web.wizard.finish.TemplateCopyOnlineOperation");
        try {
            TizenWizardFileServiceImpl metaFileService = new TizenWizardFileServiceImpl();
            if (template == null || project == null) {
                this.logger.debug("The template model or project is nothing.");
                return true;
            }
            File[] resourceFilter = new File[]{new File(".project")};
            if (template.getTemplateDescMetaInfo() == null || template.getTemplateDescMetaInfo().getZipUrl() == null) {
                this.logger.debug("The template model or project is nothing.");
                return true;
            }
            String zipUrl = template.getTemplateDescMetaInfo().getZipUrl();
            if (StringUtil.isEmpty((CharSequence)zipUrl)) {
                this.logger.debug("The template model or project is nothing.");
                return true;
            }
            IPath targetPath = project.getLocation();
            metaFileService.copySampleProject(zipUrl, targetPath.toOSString(), "project", resourceFilter);
            project.refreshLocal(2, this.createSubMonitor(monitor, 1000));
            return true;
        }
        finally {
            UserLogger.end((String)"web.wizard", (String)"web.wizard.finish.TemplateCopyOperation");
        }
    }
}

