/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentassist.SimpleCMElementDeclaration;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.eclipse.wst.xml.ui.internal.editor.CMImageUtil;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.contentassist.StringLiteralCompletionProposal;
import org.tizen.web.editor.javascript.contentassist.StringLiteralCompletionProposalComputer;
import org.tizen.web.editor.javascript.util.JavaScriptEditorUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLCompletionProposalComputer
implements JavaScriptEditorConstants {
    private XMLContentModelGenerator fGenerator;
    private IJavaCompletionProposalComputer caller;

    public HTMLCompletionProposalComputer(IJavaCompletionProposalComputer caller) {
        this.caller = caller;
    }

    public boolean validateRequest(int requestedOffset, ASTNode node) {
        boolean isValid = false;
        if (node instanceof StringLiteral) {
            String escapedValue;
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            if (requestedOffset > startPosition && requestedOffset < startPosition + length && (escapedValue = ((StringLiteral)node).getEscapedValue()) != null) {
                if (escapedValue.startsWith("'") || escapedValue.startsWith("\"")) {
                    escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
                }
                if (escapedValue.trim().equals("") || this.getMatchingString(escapedValue, node, requestedOffset) != null) {
                    isValid = true;
                }
            }
        }
        return isValid;
    }

    public String getMatchingString(String escapedValue, ASTNode node, int requestedOffset) {
        String matchingString = null;
        int startPosition = node.getStartPosition();
        int gap = requestedOffset - startPosition - 1;
        if (gap > 0) {
            String preMatchingString = escapedValue.substring(0, gap);
            if ((preMatchingString = this.leftTrim(preMatchingString)) != null && !preMatchingString.equals("")) {
                if (preMatchingString.startsWith("<")) {
                    List<CharacterPosition> openAngleBrackets = this.countCharacterOccurrences(preMatchingString, '<');
                    List<CharacterPosition> closeAngleBrackets = this.countCharacterOccurrences(preMatchingString, '>');
                    if (openAngleBrackets != null) {
                        if (openAngleBrackets.size() == 1 && closeAngleBrackets == null) {
                            matchingString = preMatchingString;
                        } else if (closeAngleBrackets != null && openAngleBrackets.size() == closeAngleBrackets.size()) {
                            matchingString = "";
                        } else if (closeAngleBrackets != null && openAngleBrackets.size() == closeAngleBrackets.size() + 1) {
                            CharacterPosition characterPosition = openAngleBrackets.get(openAngleBrackets.size() - 1);
                            matchingString = preMatchingString.substring(characterPosition.foundCharPosition);
                        }
                    }
                } else {
                    try {
                        List<CharacterPosition> openAngleBrackets = this.countCharacterOccurrences(preMatchingString, '<');
                        List<CharacterPosition> closeAngleBrackets = this.countCharacterOccurrences(preMatchingString, '>');
                        if (openAngleBrackets == null || closeAngleBrackets != null && openAngleBrackets.size() == closeAngleBrackets.size()) {
                            matchingString = "";
                        } else if (openAngleBrackets.size() == 1 && closeAngleBrackets == null || closeAngleBrackets != null && openAngleBrackets.size() == closeAngleBrackets.size() + 1) {
                            CharacterPosition characterPosition = openAngleBrackets.get(openAngleBrackets.size() - 1);
                            matchingString = preMatchingString.substring(characterPosition.foundCharPosition, gap);
                        } else {
                            String postMatchingString = escapedValue.substring(gap);
                            if (postMatchingString != null && !postMatchingString.contains(">")) {
                                matchingString = "";
                            }
                        }
                    }
                    catch (Exception exception) {
                        matchingString = null;
                    }
                }
            }
        }
        return matchingString;
    }

    private List<CharacterPosition> countCharacterOccurrences(String target, char needle) {
        ArrayList<CharacterPosition> foundCharPositions = null;
        int i = 0;
        while (i < target.length()) {
            if (target.charAt(i) == needle) {
                if (foundCharPositions == null) {
                    foundCharPositions = new ArrayList<CharacterPosition>();
                }
                CharacterPosition charPosition = new CharacterPosition(target.charAt(i), i);
                foundCharPositions.add(charPosition);
            }
            ++i;
        }
        return foundCharPositions;
    }

    public List getHTMLProposals(List<ICompletionProposal> proposals, ElementStyleImpl foundNode, IStructuredModel model, String escapedValue, String escapedValueFirstCharacter, int offset) {
        block25: {
            block24: {
                String matchString;
                Iterator nodeIterator;
                CMElementDeclaration cmElementDeclaration;
                if (foundNode.getParentNode().getNodeType() != 1) break block24;
                List cmnodes = null;
                String error = null;
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                if (modelQuery == null || (cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)foundNode)) == null) break block25;
                cmnodes = this.getAvailableChildElementDeclarations((Element)foundNode.getParentNode(), 0, 1);
                List strictCMNodeSuggestions = null;
                if ("Strict".equals(XMLUIPlugin.getInstance().getPreferenceStore().getString(XMLUIPreferenceNames.SUGGESTION_STRATEGY))) {
                    strictCMNodeSuggestions = this.getValidChildElementDeclarations((Element)foundNode.getParentNode(), 0, 1);
                }
                if (!(nodeIterator = cmnodes.iterator()).hasNext()) {
                    error = this.getCMElementDeclaration(foundNode.getParentNode()) != null ? NLS.bind((String)XMLUIMessages._Has_no_available_child, (Object[])new Object[]{foundNode.getParentNode().getNodeName()}) : NLS.bind((String)XMLUIMessages.Element__is_unknown, (Object[])new Object[]{foundNode.getParentNode().getNodeName()});
                }
                if ((matchString = escapedValue) != null) {
                    while (matchString.length() > 0 && (Character.isWhitespace(matchString.charAt(0)) || HTMLCompletionProposalComputer.beginsWith(matchString, "<"))) {
                        matchString = matchString.substring(1);
                    }
                }
                while (nodeIterator.hasNext()) {
                    Object o = nodeIterator.next();
                    if (!(o instanceof CMElementDeclaration)) continue;
                    CMElementDeclaration elementDecl = (CMElementDeclaration)o;
                    String tagname = this.getRequiredName(foundNode.getParentNode(), (CMNode)elementDecl);
                    boolean isStrictCMNodeSuggestion = strictCMNodeSuggestions != null ? strictCMNodeSuggestions.contains(elementDecl) : false;
                    Image image = CMImageUtil.getImage((CMNode)elementDecl);
                    if (image == null) {
                        image = strictCMNodeSuggestions != null ? (isStrictCMNodeSuggestion ? JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/tag_generic_emphasized_obj.png") : JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/tag_generic_deemphasized_obj.png")) : JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/tag-generic.png");
                    }
                    if (!HTMLCompletionProposalComputer.beginsWith(tagname, matchString)) continue;
                    String proposedText = this.getRequiredText(foundNode.getParentNode(), elementDecl);
                    proposedText = proposedText.toLowerCase();
                    if (escapedValueFirstCharacter != null && escapedValueFirstCharacter.equals("\"")) {
                        proposedText = proposedText.replace("\"", "'");
                    } else if (escapedValueFirstCharacter != null && escapedValueFirstCharacter.equals("'")) {
                        proposedText = proposedText.replace("'", "\"");
                    }
                    int replaceOffset = offset;
                    if (matchString != null && (!matchString.trim().equals("") || escapedValue != null && escapedValue.equals("<"))) {
                        replaceOffset = replaceOffset - matchString.length() - 1;
                    }
                    int relevance = isStrictCMNodeSuggestion ? 600 : 500;
                    StringLiteralCompletionProposal proposal = new StringLiteralCompletionProposal(proposedText, replaceOffset, proposedText.length(), image, tagname.toLowerCase(), relevance);
                    proposals.add((ICompletionProposal)proposal);
                }
                if (proposals.size() != 0) break block25;
                if (error != null) {
                    ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(error);
                } else if (matchString != null && matchString.length() > 0) {
                    ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(NLS.bind((String)XMLUIMessages.No_known_child_tag, (Object[])new Object[]{foundNode.getParentNode().getNodeName(), matchString}));
                } else {
                    ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(NLS.bind((String)XMLUIMessages.__Has_no_known_child, (Object[])new Object[]{foundNode.getParentNode().getNodeName()}));
                }
                break block25;
            }
            if (foundNode.getParentNode().getNodeType() == 9) {
                boolean xmlpiFound = false;
                boolean doctypeFound = false;
                int minimumOffset = -1;
                Node child = foundNode.getParentNode().getFirstChild();
                while (child != null) {
                    boolean doctype;
                    boolean xmlpi = child.getNodeType() == 7 && child.getNodeName().equals("xml");
                    boolean bl = doctype = child.getNodeType() == 10;
                    if (xmlpi || doctype && minimumOffset < 0) {
                        minimumOffset = ((IDOMNode)child).getFirstStructuredDocumentRegion().getStartOffset() + ((IDOMNode)child).getFirstStructuredDocumentRegion().getTextLength();
                    }
                    xmlpiFound = xmlpiFound || xmlpi;
                    doctypeFound = doctypeFound || doctype;
                    child = child.getNextSibling();
                }
                if (offset >= minimumOffset) {
                    List childDecls = this.getAvailableRootChildren((Document)foundNode.getParentNode(), 0);
                    int k = 0;
                    while (k < childDecls.size()) {
                        CMElementDeclaration ed = (CMElementDeclaration)childDecls.get(k);
                        if (ed != null) {
                            Image image = CMImageUtil.getImage((CMNode)ed);
                            if (image == null) {
                                image = JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/tag-generic.png");
                            }
                            String proposedText = this.getRequiredText(foundNode.getParentNode(), ed);
                            proposedText = proposedText.toLowerCase();
                            if (escapedValueFirstCharacter != null && escapedValueFirstCharacter.equals("\"")) {
                                proposedText = proposedText.replace("\"", "'");
                            } else if (escapedValueFirstCharacter != null && escapedValueFirstCharacter.equals("'")) {
                                proposedText = proposedText.replace("'", "\"");
                            }
                            String tagname = this.getRequiredName(foundNode.getParentNode(), (CMNode)ed);
                            StringLiteralCompletionProposal proposal = new StringLiteralCompletionProposal(proposedText, offset, proposedText.length(), image, tagname.toLowerCase(), 99);
                            proposals.add((ICompletionProposal)proposal);
                        }
                        ++k;
                    }
                }
            }
        }
        return proposals;
    }

    private List getAvailableRootChildren(Document document, int childIndex) {
        ArrayList<Object> list = null;
        DocumentType docType = document.getDoctype();
        String rootName = null;
        if (docType != null) {
            rootName = docType.getNodeName();
        }
        if (rootName == null) {
            return new ArrayList(0);
        }
        Node child = document.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase(rootName) && (!(child instanceof IDOMNode) || ((IDOMNode)child).getStartStructuredDocumentRegion() != null && ((IDOMNode)child).getEndStructuredDocumentRegion() != null)) {
                ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(NLS.bind((String)XMLUIMessages.The_document_element__, (Object[])new Object[]{rootName}));
                return new ArrayList(0);
            }
            child = child.getNextSibling();
        }
        list = new ArrayList<Object>(1);
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery != null) {
            CMDocument cmdoc = modelQuery.getCorrespondingCMDocument((Node)document);
            if (cmdoc != null) {
                if (rootName != null) {
                    CMElementDeclaration rootDecl = (CMElementDeclaration)cmdoc.getElements().getNamedItem(rootName);
                    if (rootDecl != null) {
                        list.add(rootDecl);
                    } else {
                        list.add(new SimpleCMElementDeclaration(rootName));
                        String location = (docType.getPublicId() != null ? String.valueOf(docType.getPublicId()) + "/" : "") + (docType.getSystemId() != null ? docType.getSystemId() : "");
                        if (location.length() > 0) {
                            ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(NLS.bind((String)XMLUIMessages.No_definition_for_in, (Object[])new Object[]{rootName, location}));
                        } else {
                            ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(NLS.bind((String)XMLUIMessages.No_definition_for, (Object[])new Object[]{rootName}));
                        }
                    }
                }
            } else {
                String location = (docType.getPublicId() != null ? String.valueOf(docType.getPublicId()) + "/" : "") + (docType.getSystemId() != null ? docType.getSystemId() : "");
                if (location.length() > 0) {
                    ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(NLS.bind((String)XMLUIMessages.No_content_model_for, (Object[])new Object[]{location}));
                } else {
                    ((StringLiteralCompletionProposalComputer)this.caller).setErrorMessage(XMLUIMessages.No_content_model_found_UI_);
                }
            }
        }
        return list;
    }

    private String getRequiredText(Node parentOrOwner, CMElementDeclaration elementDecl) {
        if (elementDecl == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        this.getContentGenerator().generateTag(parentOrOwner, elementDecl, buff);
        return buff.toString();
    }

    private List getAvailableChildElementDeclarations(Element parent, int childPosition, int kindOfAction) {
        List modelQueryActions = this.getAvailableModelQueryActionsAtIndex(parent, childPosition, 0);
        Iterator iterator = modelQueryActions.iterator();
        Vector<CMNode> cmnodes = new Vector<CMNode>();
        while (iterator.hasNext()) {
            CMNode actionCMNode;
            ModelQueryAction action = (ModelQueryAction)iterator.next();
            if (childPosition >= 0 && (action.getStartIndex() > childPosition || childPosition > action.getEndIndex() || action.getKind() != kindOfAction) || (actionCMNode = action.getCMNode()) == null || cmnodes.contains(actionCMNode)) continue;
            cmnodes.add(actionCMNode);
        }
        return cmnodes;
    }

    private List getAvailableModelQueryActionsAtIndex(Element parent, int index, int validityChecking) {
        ModelQuery modelQuery;
        List list = new ArrayList();
        CMElementDeclaration parentDecl = this.getCMElementDeclaration(parent);
        if (parentDecl != null && (modelQuery = ModelQueryUtil.getModelQuery((Document)parent.getOwnerDocument())) != null) {
            int ic = 2;
            modelQuery.getInsertActions(parent, parentDecl, index, ic, validityChecking, list);
        }
        list = this.filterAvailableModelQueryActions(list);
        return list;
    }

    private CMElementDeclaration getCMElementDeclaration(Node node) {
        ModelQuery modelQuery;
        CMElementDeclaration result = null;
        if (node.getNodeType() == 1 && (modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null) {
            result = modelQuery.getCMElementDeclaration((Element)node);
        }
        return result;
    }

    private List filterAvailableModelQueryActions(List modelQueryActions) {
        ArrayList<ModelQueryAction> filtered = new ArrayList<ModelQueryAction>(modelQueryActions.size());
        for (ModelQueryAction action : modelQueryActions) {
            if (!this.validModelQueryNode(action.getCMNode())) continue;
            filtered.add(action);
        }
        return filtered;
    }

    public boolean validModelQueryNode(CMNode node) {
        return true;
    }

    private List getValidChildElementDeclarations(Element parent, int childPosition, int kindOfAction) {
        List modelQueryActions = this.getAvailableModelQueryActionsAtIndex(parent, childPosition, 2);
        Iterator iterator = modelQueryActions.iterator();
        Vector<CMNode> cmnodes = new Vector<CMNode>();
        while (iterator.hasNext()) {
            CMNode actionCMNode;
            ModelQueryAction action = (ModelQueryAction)iterator.next();
            if (childPosition >= 0 && (action.getStartIndex() > childPosition || childPosition > action.getEndIndex() || action.getKind() != kindOfAction) || (actionCMNode = action.getCMNode()) == null || cmnodes.contains(actionCMNode)) continue;
            cmnodes.add(actionCMNode);
        }
        return cmnodes;
    }

    private static boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null) {
            return true;
        }
        return aString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private String getRequiredName(Node parentOrOwner, CMNode cmnode) {
        if (cmnode == null || parentOrOwner == null) {
            return "";
        }
        return this.getContentGenerator().getRequiredName(parentOrOwner, cmnode);
    }

    private XMLContentModelGenerator getContentGenerator() {
        if (this.fGenerator == null) {
            this.fGenerator = new XMLContentModelGenerator();
        }
        return this.fGenerator;
    }

    public String leftTrim(String s) {
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return s.substring(i);
    }

    public String rightTrim(String s) {
        int i = s.length() - 1;
        while (i >= 0 && Character.isWhitespace(s.charAt(i))) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    static class CharacterPosition {
        char findChar;
        int foundCharPosition;

        CharacterPosition(char findChar, int foundCharPosition) {
            this.findChar = findChar;
            this.foundCharPosition = foundCharPosition;
        }
    }
}

