/*
 * Decompiled with CFR 0.152.
 */
package json.model.folding;

import java.util.LinkedList;
import java.util.List;
import json.model.jsonnode.JsonNode;
import json.model.jsonnode.JsonType;
import json.model.node.Node;
import org.eclipse.jface.text.Position;

public class JsonFoldingPositionsBuilder {
    private List<JsonNode> jsonNodes;

    public JsonFoldingPositionsBuilder(List<JsonNode> jsonNodes) {
        this.jsonNodes = jsonNodes;
    }

    public List<Position> buildFoldingPositions() {
        LinkedList<Position> positions = new LinkedList<Position>();
        LinkedList<Position> positionsStack = new LinkedList<Position>();
        if (this.jsonNodes != null) {
            for (JsonNode jsonNode : this.jsonNodes) {
                Position position;
                if (this.isJsonNodeType(jsonNode, JsonType.Array, JsonType.Object)) {
                    position = new Position(this.getStart(jsonNode));
                    positionsStack.add(0, position);
                    positions.add(position);
                }
                if (!this.isJsonNodeType(jsonNode, JsonType.End) || positionsStack.size() <= 0) continue;
                position = (Position)positionsStack.remove(0);
                position.setLength(this.getEnd(jsonNode) - position.getOffset());
            }
        }
        return positions;
    }

    private boolean isJsonNodeType(JsonNode jsonNode, JsonType ... jsonTypes) {
        JsonType[] jsonTypeArray = jsonTypes;
        int n = jsonTypes.length;
        int n2 = 0;
        while (n2 < n) {
            JsonType jsonType = jsonTypeArray[n2];
            if (jsonNode.getJsonType() == jsonType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getStart(JsonNode jsonNode) {
        Node startNode = jsonNode.getKey();
        if (startNode == null) {
            startNode = jsonNode.getValue();
        }
        return startNode.getStart();
    }

    public int getEnd(JsonNode jsonNode) {
        Node endNode = jsonNode.getValue();
        if (endNode == null) {
            endNode = jsonNode.getKey();
        }
        if (endNode == null) {
            return 0;
        }
        return endNode.getEnd();
    }
}

