/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.util.WorkspaceUtil;
import org.tizen.web.common.build.CleanJob;
import org.tizen.web.common.build.PropertyChangeCleanListener;
import org.tizen.web.privilege.Activator;
import org.tizen.web.privilege.preferences.Messages;
import org.tizen.web.privilege.preferences.PrivilegePreferenceConstants;

public class PrivilegePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor buildField;
    private BooleanFieldEditor reconcileField;
    private ComboFieldEditor levelField;
    private final List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();
    private PropertyChangeCleanListener changeListener = new PropertyChangeCleanListener();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = 1;
        result.setLayout((Layout)layout);
        Group validationGroup = new Group(result, 0);
        validationGroup.setText(Messages.PrivilegePreferencePage_GroupLabel);
        GridLayout validationGroupLayout = new GridLayout();
        GridData validationGroupLayoutData = new GridData(1808);
        validationGroup.setLayout((Layout)validationGroupLayout);
        validationGroup.setLayoutData((Object)validationGroupLayoutData);
        Label lblInfo = new Label((Composite)validationGroup, 16384);
        lblInfo.setText(Messages.PrivilegePreferencePage_GroupDescription);
        lblInfo.setLayoutData((Object)new GridData());
        Group buildOptionGroup = new Group((Composite)validationGroup, 0);
        buildOptionGroup.setText(Messages.PrivilegePreferencePage_BuildOptionLabel);
        GridLayout buildOptionLayout = new GridLayout();
        GridData buildOptionLayoutGridData = new GridData(768);
        buildOptionGroup.setLayout((Layout)buildOptionLayout);
        buildOptionGroup.setLayoutData((Object)buildOptionLayoutGridData);
        Composite buildOptionInner = new Composite((Composite)buildOptionGroup, 0);
        buildOptionInner.setLayoutData((Object)new GridData());
        this.buildField = new BooleanFieldEditor("org.tizen.web.privilege.preference.PrivilegePreferencePage.build", Messages.PrivilegePreferencePage_BuildLabel, buildOptionInner);
        this.reconcileField = new BooleanFieldEditor("org.tizen.web.privilege.preference.PrivilegePreferencePage.reconcile", Messages.PrivilegePreferencePage_ReconcileLabel, buildOptionInner);
        this.levelField = new ComboFieldEditor("org.tizen.web.privilege.preference.PrivilegePreferencePage.level", Messages.PrivilegePreferencePage_LevelLabel, PrivilegePreferenceConstants.LEVEL_LISTS, buildOptionInner);
        Group buildPropertyGroup = new Group((Composite)validationGroup, 0);
        buildPropertyGroup.setText(Messages.PrivilegePreferencePage_BuildPropertyLabel);
        GridLayout buildPropertyLayout = new GridLayout();
        GridData buildPropertyLayoutGridData = new GridData(768);
        buildPropertyGroup.setLayout((Layout)buildPropertyLayout);
        buildPropertyGroup.setLayoutData((Object)buildPropertyLayoutGridData);
        Composite buildPropertyInner = new Composite((Composite)buildPropertyGroup, 0);
        buildPropertyInner.setLayoutData((Object)new GridData());
        this.addFieldEditor((FieldEditor)new StringFieldEditor("org.tizen.web.privilege.preference.PrivilegePreferencePage.excludeFile", Messages.PrivilegePreferencePage_ExcludeFileLabel, 30, buildPropertyInner));
        this.addFieldEditor((FieldEditor)new StringFieldEditor("org.tizen.web.privilege.preference.PrivilegePreferencePage.excludeFolder", Messages.PrivilegePreferencePage_ExcludeFolderLabel, 30, buildPropertyInner));
        this.setPreferenceStore();
        this.loadPreference();
        this.buildField.setPropertyChangeListener((IPropertyChangeListener)this.changeListener);
        this.reconcileField.setPropertyChangeListener((IPropertyChangeListener)this.changeListener);
        this.levelField.setPropertyChangeListener((IPropertyChangeListener)this.changeListener);
        return result;
    }

    private void addFieldEditor(FieldEditor fieldEditor) {
        fieldEditor.setPage((DialogPage)this);
        this.fieldEditors.add(fieldEditor);
    }

    public boolean performOk() {
        if (this.changeListener.needToClean()) {
            CleanJob cleanJob = new CleanJob();
            cleanJob.run(WorkspaceUtil.getTizenWebProjects());
        }
        this.storePreference();
        return super.performOk();
    }

    protected void performDefaults() {
        this.loadDefaultPreference();
        super.performDefaults();
    }

    private void setPreferenceStore() {
        IPreferenceStore ps = this.getPreferenceStore();
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.setPreferenceStore(ps);
        }
        this.buildField.setPreferenceStore(ps);
        this.reconcileField.setPreferenceStore(ps);
        this.levelField.setPreferenceStore(ps);
    }

    private void loadPreference() {
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.load();
        }
        this.buildField.load();
        this.reconcileField.load();
        this.levelField.load();
    }

    private void storePreference() {
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.store();
        }
        this.buildField.store();
        this.reconcileField.store();
        this.levelField.store();
    }

    private void loadDefaultPreference() {
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.loadDefault();
        }
        this.buildField.loadDefault();
        this.reconcileField.loadDefault();
        this.levelField.loadDefault();
    }
}

