/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.project.wizard.extension.WebProjectCreator;
import org.tizen.web.project.wizard.operation.DefaultNatureOperation;

public class ConvertToProjectDescription
implements IObjectActionDelegate {
    private final Logger logger = LoggerFactory.getLogger(ConvertToProjectDescription.class);
    private IProject selectedProject;

    public void run(IAction action) {
        try {
            IProjectDescription newDes = ResourcesPlugin.getWorkspace().newProjectDescription(this.selectedProject.getName());
            this.selectedProject.setDescription(newDes, null);
            DefaultNatureOperation newNature = new DefaultNatureOperation();
            newNature.execute(null, this.selectedProject, null);
            WebProjectCreator creator = new WebProjectCreator(this.selectedProject);
            creator.initializeConfigurationForImport(null);
        }
        catch (CoreException e) {
            this.logger.error("Failed to convert", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Failed to convert", (Throwable)e);
        }
        catch (ConfigurationException e) {
            this.logger.error("Failed to convert", (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object selectedObject;
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            this.selectedProject = (IProject)selectedObject;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

