/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.ide.visitor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.tizen.common.util.Assert;
import org.tizen.web.common.util.PackageUtil;
import org.tizen.web.editor.configuration.validation.NonSchemaBasedValidator;
import org.tizen.web.editor.configuration.validation.SchemaBasedValidator;

public class WebConfigValidationVisitor
implements IResourceDeltaVisitor,
IResourceVisitor {
    private SchemaBasedValidator schemaValidator = new SchemaBasedValidator();
    private NonSchemaBasedValidator nonSchemaValidator = new NonSchemaBasedValidator();
    private String pkgName;
    private boolean hasDeltaOfRemovedPkg;
    private boolean hasDelta;
    private IProject project;
    private boolean checkedConfiguration;

    public WebConfigValidationVisitor(IProject project) {
        Assert.notNull((Object)project);
        this.project = project;
        this.pkgName = PackageUtil.getPackageName((IProject)project);
        this.hasDeltaOfRemovedPkg = false;
        this.hasDelta = false;
        this.checkedConfiguration = false;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (1 != resource.getType()) {
            return true;
        }
        IFile file = (IFile)resource;
        if (resource.getParent().equals((Object)this.project)) {
            this.validateConfiguration(file);
        }
        return true;
    }

    private void validateConfiguration(IFile file) {
        if (this.checkedConfiguration) {
            return;
        }
        if ("config.xml".equalsIgnoreCase(file.getName())) {
            this.checkedConfiguration = true;
            this.nonSchemaValidator.validateConfigurationDocument(file);
            this.schemaValidator.validateConfigurationDocument(file);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (!this.hasDelta) {
            this.hasDelta = true;
        }
        IResource resource = delta.getResource();
        if (2 == delta.getKind() && this.pkgName.equals(resource.getName())) {
            this.hasDeltaOfRemovedPkg = true;
        }
        IFile configFile = this.project.getFile("config.xml");
        this.validateConfiguration(configFile);
        return this.visit(resource);
    }

    public boolean hasDeltaOfRemovedPkg() {
        return this.hasDeltaOfRemovedPkg;
    }

    public boolean hasDelta() {
        return this.hasDelta;
    }
}

