/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.deployer;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsDeployer;
import org.tizen.common.sign.signer.SignatureGenerator;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ISdbCommandHelper;
import org.tizen.sdblib.IDevice;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.packager.ui.util.PackageUtil;
import org.tizen.web.zimlaunch.exception.NoConnectedDeviceException;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class WebRdsDeployer
extends RdsDeployer {
    protected static final Logger logger = LoggerFactory.getLogger(WebRdsDeployer.class);
    public static final String DIRECTORY_INSTALL_CMD = "Directory Install Command : ";
    protected TizenWebNotifier notifier;
    protected int work = 0;
    private String packageId;

    public WebRdsDeployer(IProject project, IDevice device, ISdbCommandHelper tizenCommand, ITizenConsoleManager console, String pkgType, String packageId, IProgressMonitor monitor) {
        super(project, device, tizenCommand, console, pkgType, monitor);
        this.packageId = packageId;
    }

    protected boolean sign(List<DeltaResourceInfo> deltaInfoList) throws CoreException, IOException, IllegalStateException {
        if (!ProjectUtil.isHybridApp((IProject)this.project)) {
            this.remakeDeltaListForSign(deltaInfoList);
        }
        this.incrementalSign(deltaInfoList);
        return true;
    }

    private void remakeDeltaListForSign(List<DeltaResourceInfo> deltaList) {
        String remotePath = null;
        String remakeRemotePath = null;
        for (DeltaResourceInfo delta : deltaList) {
            remotePath = delta.getRemotePath();
            remakeRemotePath = remotePath.replaceFirst("res/wgt/", "");
            delta.setRemotePath(remakeRemotePath);
            List childrenDris = delta.getChildren();
            if (childrenDris.isEmpty()) continue;
            this.remakeDeltaListForSign(delta.getChildren());
        }
    }

    protected void incrementalSign(List<DeltaResourceInfo> deltaList) throws CoreException {
        File file = new File(FileUtil.appendPath((String)this.project.getLocation().toOSString(), (String)".sign"));
        file.mkdir();
        SignatureGenerator.generate((IProject)this.project, (IContainer)this.project.getFolder(".sign"), (IDevice)this.device, deltaList);
    }

    public boolean isDeltaChanged(String name) {
        boolean isDeltaChanged = false;
        if (!this.hasOldResourceInfo()) {
            return isDeltaChanged;
        }
        List deltaInfoList = this.getDelta();
        if (CollectionUtil.isEmpty((Collection)deltaInfoList)) {
            return isDeltaChanged;
        }
        for (DeltaResourceInfo node : deltaInfoList) {
            if (!name.equals(node.getName()) || !"modify".equals(node.getType())) continue;
            isDeltaChanged = true;
            break;
        }
        return isDeltaChanged;
    }

    protected void printInfo(String message, int work) {
        if (this.notifier == null) {
            return;
        }
        this.notifier.notifyContents(message, work);
    }

    protected void printInfo(String message) {
        this.printInfo(message, 0);
    }

    protected String getAppInstallPath() {
        String pkgName = "";
        try {
            pkgName = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)this.project).getApplicationPackage();
            return String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)this.device)) + "/" + pkgName;
        }
        catch (ConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected String getDirectoryInstallPath() {
        CommandLauncher launcher = null;
        String pkgName = "";
        try {
            launcher = new CommandLauncher(this.device);
            pkgName = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)this.project).getApplicationPackage();
            return String.valueOf(launcher.getAppInstallPath()) + "/" + pkgName;
        }
        catch (ConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NoConnectedDeviceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public int getWork() {
        return this.work;
    }

    public void setWork(int work) {
        this.work = work;
    }

    public TizenWebNotifier getNotifier() {
        return this.notifier;
    }

    public void setNotifier(TizenWebNotifier notifier) {
        this.notifier = notifier;
    }

    protected String getPkgId() {
        return this.packageId;
    }

    protected void mergeApplicationXML() {
        try {
            PackageUtil.makeNativeManifestFile((IProject)this.project, (FileHandler)new StandardFileHandler(this.project.getLocation().toOSString()));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

