/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tizen.web.zimlaunch.util.PortItem;

public class PortUtil {
    private HashMap<String, PortItem> map = new HashMap();

    private PortUtil() {
    }

    public static PortUtil getInstance() {
        return PortUtilHolder.instance;
    }

    public PortItem getPortItem(String deviceID) {
        return this.map.get(deviceID);
    }

    public int getLocalPort(String deviceID, String appID) {
        PortItem item = this.getPortItem(deviceID);
        if (item == null) {
            return -1;
        }
        int port = item.getLocalPort(appID);
        if (port > 65535 || port < 0) {
            return -1;
        }
        return port;
    }

    public int getRemotePort(String deviceID, String appID) {
        PortItem item = this.getPortItem(deviceID);
        if (item == null) {
            return -1;
        }
        int port = item.getRemotePort(appID);
        if (port > 65535 || port < 0) {
            return -1;
        }
        return port;
    }

    public PortItem setPortItem(String deviceID, PortItem item) {
        if (deviceID == null) {
            return null;
        }
        return this.map.put(deviceID, item);
    }

    public PortItem setPortItem(String deviceID, String appID, int lport, int rport) {
        if (deviceID == null || appID == null) {
            return null;
        }
        PortItem item = this.getPortItem(deviceID);
        if (item == null) {
            item = new PortItem();
        }
        item.setPorts(appID, lport, rport);
        return this.setPortItem(deviceID, item);
    }

    public List<Integer> getAllLocalPortCurrentUsing() {
        ArrayList<Integer> lports = new ArrayList<Integer>();
        for (String deviceID : this.map.keySet()) {
            PortItem item = this.map.get(deviceID);
            for (String appID : item.getPortItemMap().keySet()) {
                int lport = item.getLocalPort(appID);
                lports.add(lport);
            }
        }
        return lports;
    }

    public void removeAllPortItem() {
        this.map.clear();
    }

    public void removePortItem(String deviceID) {
        this.map.remove(deviceID);
    }

    public void removePortItem(String deviceID, String appID) {
        PortItem item = this.getPortItem(deviceID);
        if (item == null) {
            return;
        }
        item.removePorts(appID);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    /* synthetic */ PortUtil(PortUtil portUtil) {
        this();
    }

    private static class PortUtilHolder {
        private static final PortUtil instance = new PortUtil(null);

        private PortUtilHolder() {
        }
    }
}

