/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jshint.handlers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.jshint.Activator;
import org.tizen.web.jshint.JsHintValidatorHelper;
import org.tizen.web.jshint.engine.Issue;
import org.tizen.web.jshint.engine.JsHint;
import org.tizen.web.jshint.engine.JsHintResult;

public class JsValidationHandler
extends AbstractHandler {
    protected static final Logger logger = LoggerFactory.getLogger(JsValidationHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        UserLogger.event((String)"check.js");
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        logger.trace("Selection: {}", (Object)selection);
        if (selection instanceof ITreeSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            IFile file = (IFile)object;
            JsValidationHandler.runValidation(file, null);
        } else {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            JsValidationHandler.runValidation(editor);
        }
        return null;
    }

    public static void runValidation(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        FileEditorInput fileInput = (FileEditorInput)editor.getEditorInput();
        IFile file = fileInput.getFile();
        JsValidationHandler.runValidation(file, editor);
    }

    public static void runValidation(IFile file, IEditorPart editor) {
        block8: {
            if (file == null || JsValidationHandler.isExcludeResource(file)) {
                return;
            }
            InputStream is = null;
            try {
                try {
                    if (editor != null && editor instanceof ITextEditor) {
                        IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
                        IDocument doc = provider.getDocument((Object)editor.getEditorInput());
                        is = StringUtil.toInputStream((String)doc.get());
                    } else {
                        is = file.getContents();
                    }
                    JsValidationHandler.validate((IResource)file, is);
                }
                catch (CoreException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{is});
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
    }

    public static void validate(IResource resource, InputStream is) throws CoreException {
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        String ext = file.getFileExtension();
        if (!"js".equalsIgnoreCase(ext)) {
            return;
        }
        try {
            file.deleteMarkers("org.tizen.web.builder.marker.js.lint", true, 0);
            int severity = 1;
            int priority = 1;
            String errorLevel = Activator.getDefault().getPreferenceStore().getString("org.tizen.web.jshint.preference.JsValidationPreferencePage.level");
            if (errorLevel.equalsIgnoreCase("IGNORE")) {
                return;
            }
            if (errorLevel.equalsIgnoreCase("ERROR")) {
                severity = 2;
                priority = 2;
            }
            JsHint lint = JsHint.getInstance();
            lint.resetOptions();
            JsHintValidatorHelper.setPreferenceOptions(lint);
            JsHintResult lintResult = null;
            if (is == null) {
                is = file.getContents();
            }
            InputStreamReader in = null;
            try {
                in = new InputStreamReader(is);
                lintResult = lint.lint(file.getName(), new BufferedReader(in));
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{in});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{in});
            for (Issue issue : lintResult.getIssues()) {
                IMarker marker = file.createMarker("org.tizen.web.builder.marker.js.lint");
                marker.setAttribute("message", (Object)issue.getReason());
                marker.setAttribute("lineNumber", issue.getLine());
                marker.setAttribute("severity", severity);
                marker.setAttribute("priority", priority);
            }
        }
        catch (IOException e) {
            IMarker marker = file.createMarker("org.tizen.web.builder.marker.js.lint");
            marker.setAttribute("message", (Object)e.getLocalizedMessage());
            marker.setAttribute("severity", 1);
            marker.setAttribute("priority", 1);
        }
    }

    public static boolean isExcludeResource(IFile file) {
        String[] folders;
        String[] stringArray = folders = JsHintValidatorHelper.getExcludeFolders();
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IPath filePath;
            String folder = stringArray[n2];
            IPath folderPath = file.getProject().getFolder(folder).getFullPath();
            if (folderPath.isPrefixOf(filePath = file.getFullPath())) {
                JsValidationHandler.deleteMarkers(file);
                return true;
            }
            ++n2;
        }
        String[] files = JsHintValidatorHelper.getExcludeJsResources();
        int i = 0;
        while (i < files.length) {
            if (file.getName().indexOf(files[i].trim()) != -1) {
                JsValidationHandler.deleteMarkers(file);
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers("org.tizen.web.builder.marker.js.lint", true, 0);
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

