/*
 * Decompiled with CFR 0.152.
 */
package json.outline.node;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import json.JsonEditorPlugin;
import json.model.jsonnode.JsonNode;
import json.model.jsonnode.JsonType;
import json.model.node.Node;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class JsonTreeNode {
    private JsonNode jsonNode;
    private JsonTreeNode parent;
    private boolean textSelection;
    private Image image;
    private static final Map<JsonType, String> imageMap = new HashMap<JsonType, String>();
    private static final Map<JsonType, StyledString.Styler> styleMap = new HashMap<JsonType, StyledString.Styler>();
    private List<JsonTreeNode> children = new LinkedList<JsonTreeNode>();

    static {
        imageMap.put(JsonType.Array, "/icons/JsonArray.png");
        imageMap.put(JsonType.Object, "/icons/JsonObject.png");
        imageMap.put(JsonType.True, "/icons/JsonBoolean.png");
        imageMap.put(JsonType.False, "/icons/JsonBoolean.png");
        imageMap.put(JsonType.Value, "/icons/JsonNumber.png");
        imageMap.put(JsonType.Null, "/icons/JsonNull.png");
        imageMap.put(JsonType.String, "/icons/JsonString.png");
        imageMap.put(JsonType.Error, "/icons/JsonError.png");
        styleMap.put(JsonType.String, StyledString.createColorRegistryStyler((String)"GREEN", (String)"WHITE"));
        styleMap.put(JsonType.True, StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE"));
        styleMap.put(JsonType.False, StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE"));
        styleMap.put(JsonType.Error, StyledString.createColorRegistryStyler((String)"RED", (String)"WHITE"));
        styleMap.put(JsonType.Value, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
        styleMap.put(JsonType.Null, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
        styleMap.put(JsonType.Object, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
        styleMap.put(JsonType.Array, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
    }

    public JsonTreeNode(JsonNode jsonNode, JsonTreeNode parent) {
        this.jsonNode = jsonNode;
        this.parent = parent;
    }

    public void removeEntry(JsonTreeNode jsonTreeNode) {
        this.children.remove(jsonTreeNode);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void clearChildren() {
        this.children.clear();
    }

    public List<JsonTreeNode> getChildren() {
        return this.children;
    }

    public void addChild(JsonTreeNode jsonTreeNode) {
        this.children.add(jsonTreeNode);
    }

    public void setParent(JsonTreeNode parent) {
        this.parent = parent;
    }

    public JsonTreeNode getParent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (this.getParent() != null) {
            this.getParent().removeEntry(this);
        }
    }

    public boolean isTextSelection() {
        return this.textSelection;
    }

    public void setTextSelection(boolean textSelection) {
        this.textSelection = textSelection;
    }

    public StyledString getStyledString() {
        StyledString styledString = new StyledString();
        if (this.jsonNode.getKey() != null) {
            StyledString.Styler style1 = StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE");
            styledString.append(this.jsonNode.getKey().getValue(), style1);
            StyledString.Styler style2 = StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE");
            styledString.append(" : ", style2);
        }
        if (this.jsonNode.getValue() != null && this.jsonNode.getJsonType() != JsonType.Object && this.jsonNode.getJsonType() != JsonType.Array) {
            StyledString.Styler style3 = styleMap.get((Object)this.jsonNode.getJsonType());
            styledString.append(this.jsonNode.getValue().getValue(), style3);
        }
        return styledString;
    }

    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        this.image = this.createMyImage(imageMap.get((Object)this.jsonNode.getJsonType()));
        return this.image;
    }

    private Image createMyImage(String urlPath) {
        ImageDescriptor imgDescriptor = null;
        imgDescriptor = JsonEditorPlugin.imageDescriptorFromPlugin((String)JsonEditorPlugin.getDefault().getBundle().getSymbolicName(), (String)urlPath);
        return imgDescriptor.createImage();
    }

    public int getStart() {
        Node startNode = this.jsonNode.getKey();
        if (startNode == null) {
            startNode = this.jsonNode.getValue();
        }
        return startNode.getStart();
    }

    public int getLength() {
        Node endNode;
        Node startNode = this.jsonNode.getKey();
        if (startNode == null) {
            startNode = this.jsonNode.getValue();
        }
        if ((endNode = this.jsonNode.getValue()) == null) {
            endNode = this.jsonNode.getKey();
        }
        return endNode.getEnd() - startNode.getStart();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.jsonNode == null ? 0 : this.jsonNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonTreeNode other = (JsonTreeNode)obj;
        return !(this.jsonNode == null ? other.jsonNode != null : !this.jsonNode.equals(other.jsonNode));
    }

    public JsonType getType() {
        return this.jsonNode.getJsonType();
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    public void setJsonNode(JsonNode jsonNode) {
        this.image = null;
        this.jsonNode = jsonNode;
    }
}

