/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.tizen.web.localization.LocaleItem;

public class AssociationsTableModelProvider {
    private static AssociationsTableModelProvider content;
    private HashMap<IFile, List<LocaleItem>> elements = new HashMap();

    public static synchronized AssociationsTableModelProvider getInstance() {
        if (content != null) {
            return content;
        }
        content = new AssociationsTableModelProvider();
        return content;
    }

    public void addElement(IFile key, List<LocaleItem> value) {
        this.elements.put(key, value);
    }

    public void addElements(Set<Map.Entry<IFile, List<LocaleItem>>> elements) {
        for (Map.Entry<IFile, List<LocaleItem>> entry : elements) {
            AssociationsTableModelProvider.getInstance().addElement(entry.getKey(), entry.getValue());
        }
    }

    public void removeElement(IFile key) {
        this.elements.remove(key);
    }

    public void removeElements(Set<IFile> keys) {
        for (IFile key : keys) {
            this.removeElement(key);
        }
    }

    public void clear() {
        this.elements.clear();
    }

    public List<LocaleItem> getElements(IFile key) {
        return this.elements.get(key);
    }

    public HashMap<IFile, List<LocaleItem>> getElements() {
        return this.elements;
    }
}

