/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.livereload.daemon;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.component.LifeCycle;
import org.tizen.common.daemon.AbstractServer;
import org.tizen.common.daemon.ServerException;
import org.tizen.common.daemon.ServerState;

public class WebServer
extends AbstractServer
implements LifeCycle.Listener {
    protected Connector connector;
    protected Server server;
    protected int port = 0;
    protected Handler handler;

    public WebServer(Handler handler) {
        this.handler = handler;
        this.logger.info("Handler :{}", (Object)this.handler);
    }

    public int getPort() {
        this.lock.lock();
        try {
            if (this.connector != null && this.connector.isStarted()) {
                int n = this.connector.getLocalPort();
                return n;
            }
            int n = this.port;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setPort(int port) {
        this.lock.lock();
        try {
            if (!this.isState(new ServerState[]{ServerState.Terminated})) {
                throw new IllegalStateException();
            }
            this.port = port;
            this.logger.info("Port :{}", (Object)port);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws ServerException {
        try {
            this.connector = new SelectChannelConnector();
            this.connector.setPort(this.port);
            this.server = new Server();
            this.server.addLifeCycleListener((LifeCycle.Listener)this);
            this.server.setConnectors(new Connector[]{this.connector});
            this.server.setHandler(this.handler);
            this.server.start();
            while (!this.server.isRunning()) {
                WebServer webServer = this;
                synchronized (webServer) {
                    ((Object)((Object)this)).wait(1000L);
                }
            }
            this.logger.info("webserver initialized");
        }
        catch (Exception e) {
            throw new ServerException((Throwable)e);
        }
    }

    protected void process() throws Exception {
    }

    protected void terminate() {
        try {
            this.server.stop();
            this.logger.info("webserver terminated");
        }
        catch (Exception e) {
            this.logger.trace(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifeCycleStarting(LifeCycle paramLifeCycle) {
        this.logger.debug("lifecycle starting");
        WebServer webServer = this;
        synchronized (webServer) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifeCycleStarted(LifeCycle paramLifeCycle) {
        this.logger.debug("lifecycle started");
        WebServer webServer = this;
        synchronized (webServer) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
        this.logger.debug("lifecycle failure", throwable);
        WebServer webServer = this;
        synchronized (webServer) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifeCycleStopping(LifeCycle lifeCycle) {
        this.logger.debug("lifecycle stopping");
        WebServer webServer = this;
        synchronized (webServer) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifeCycleStopped(LifeCycle lifeCycle) {
        this.logger.debug("lifecycle stopped");
        WebServer webServer = this;
        synchronized (webServer) {
            ((Object)((Object)this)).notifyAll();
        }
    }
}

