/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;
import org.tizen.web.project.wizard.ui.TizenWebProjectCreator;

public class TemplateCopyOperation
extends AbstractProjectTemplateOperation {
    public static final String RESOURCE_FOLDER_NAME = "project";

    public TemplateCopyOperation() {
        this.setMainTask(WizardMessages.NewWizardCopyTemplateOperationTask);
    }

    @Override
    public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        UserLogger.start((String)"web.wizard", (String)"web.wizard.finish.TemplateCopyOperation");
        try {
            if (template == null || project == null) {
                this.logger.debug("The template model or project is nothing.");
                return true;
            }
            Path sourcePath = new Path(template.getZipUrl());
            if (!sourcePath.toFile().exists()) {
                throw this.createCoreException(4, WizardMessages.TEMPLATE_PROJECT_NOT_FOUND);
            }
            IPath targetPath = project.getLocation();
            File[] resourceFilter = new File[]{sourcePath.append(".project").toFile()};
            FileUtil.copyRecursively((String)sourcePath.toOSString(), (String)targetPath.toOSString(), (boolean)true, (File[])resourceFilter);
            this.copyAdditionalFiles(template, project);
            this.renameWebWidgetDirectory(template, project);
            project.refreshLocal(2, this.createSubMonitor(monitor, 1000));
            return true;
        }
        finally {
            UserLogger.end((String)"web.wizard", (String)"web.wizard.finish.TemplateCopyOperation");
        }
    }

    private void renameWebWidgetDirectory(ProjectTemplate template, IProject project) throws CoreException {
        if (TizenWebProjectCreator.isWebWidgetTemplate(template)) {
            String rootWidget = String.valueOf(File.separator) + "widget" + File.separator;
            String rootWidgetPath = String.valueOf(project.getLocation().toOSString()) + rootWidget;
            File[] widgetDirectory = new File(rootWidgetPath).listFiles();
            if (widgetDirectory != null && widgetDirectory[0].isDirectory()) {
                widgetDirectory[0].renameTo(new File(String.valueOf(rootWidgetPath) + project.getName()));
            } else {
                throw this.createCoreException(4, WizardMessages.bind((String)WizardMessages.FAIL_TO_RENAME_WEBWIDGET_DIRECTORY, (Object)template.getSamplePath()));
            }
        }
    }

    private void copyAdditionalFiles(ProjectTemplate template, IProject project) {
        HashMap<File, File> additionalFiles = new HashMap<File, File>();
        if (TizenWebProjectCreator.isWebWidgetTemplate(template)) {
            URL defaultLibFile = PluginUtil.getFileURLinBundle((String)"org.tizen.web.project.wizard", (String)"templateLibraries/jsdtscope");
            File dest = project.getFile(".settings/.jsdtscope").getLocation().toFile();
            additionalFiles.put(new File(defaultLibFile.getFile()), dest);
        }
        for (File file : additionalFiles.keySet()) {
            try {
                FileUtil.copyTo((File)file, (File)((File)additionalFiles.get(file)), (boolean)false);
            }
            catch (IOException e) {
                this.logger.error("Failed to copy file(" + file + ") to dest(" + additionalFiles.get(file) + ")", (Throwable)e);
            }
        }
    }
}

