/*
 * Web IDE - beautifier
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Changhyun Lee <changhyun1.lee@samsung.com>
 * Hyeongseok Heo <hyeongseok.heo@samsung.com>
 * BonYong Lee <bonyong.lee@samsung.com>
 * Kangho Kim <kh5325.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.web.compressor.beautifier.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * IBeautifier. Interface for beautifier
 * @author ChangHyun Lee{@literal <changhyun1.lee@samsung.com>} (S-Core)
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 */
public interface IBeautifier {
    /**
     * Return if can handle file with {@code name}
     * @param name file name
     * @return if can handle
     */
    boolean canHandle(final String name);

    /**
     * Read from {@code source}, beautify contents, and write {@code target}
     * @param source {@link InputStream} to read
     * @param target {@link OutputStream} to write
     * @throws IOException If can't read or write
     */
    void decompress(InputStream source, OutputStream target) throws IOException;

}
