/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class RdsKillStep
extends CompositeStep {
    protected CommandLauncher launcher;
    protected ZimLaunchResource resource;
    protected static final Logger logger = LoggerFactory.getLogger(RdsKillStep.class);

    public RdsKillStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        this.preExecuteStep(ctx);
        String cmd = this.getLaunchCommand();
        this.launcher.runCommand(cmd, true);
    }

    protected String getLaunchCommand() throws Exception {
        return String.valueOf(this.launcher.getCommand("KILL_COMMAND", this.resource)) + TizenWebLaunchConstants.WRT_CMD_RESULT_CHECK;
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
    }
}

