/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.preference;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.Activator;
import org.tizen.web.editor.Messages;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Text excludedFoldersText;
    private String oldExcludedFoldersText;

    public EditorPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        result.setLayout((Layout)layout);
        Group contentAssitExcludedFolderGroup = new Group(result, 0);
        contentAssitExcludedFolderGroup.setText(Messages.EditorPreferencePage_GroupEditorAdvancedFeature);
        GridLayout layout3 = new GridLayout();
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 2;
        layout3.numColumns = 2;
        contentAssitExcludedFolderGroup.setLayout((Layout)layout3);
        contentAssitExcludedFolderGroup.setLayoutData((Object)gd1);
        Composite excludedComp = new Composite((Composite)contentAssitExcludedFolderGroup, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.verticalSpacing = 1;
        excludedComp.setLayout((Layout)gl);
        excludedComp.setLayoutData((Object)new GridData(4, 128, true, true));
        Label excludedFoldersLabel = new Label(excludedComp, 0);
        excludedFoldersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        excludedFoldersLabel.setText(Messages.EditorPreferencePage_GroupEditorAdvancedFeature_Excluded_List);
        this.excludedFoldersText = new Text(excludedComp, 2048);
        this.excludedFoldersText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.excludedFoldersText.setSize(10, this.excludedFoldersText.getSize().y);
        IPreferenceStore prefs = this.getPreferenceStore();
        String excludedFolderList = prefs.getDefaultString("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY");
        if (excludedFolderList == null || excludedFolderList.equals("")) {
            prefs.setDefault("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY", "tau,tizen-web-ui-fw,tizen-ui-builder-fw,cultures,cowhide,lib,.build");
        }
        excludedFolderList = prefs.getString("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY");
        this.excludedFoldersText.setText(excludedFolderList);
        this.setOldExcludedFoldersText(excludedFolderList);
        Label emptyLabel = new Label(excludedComp, 0);
        emptyLabel.setText("");
        emptyLabel = new Label(excludedComp, 0);
        emptyLabel.setText("");
        Label excludedFoldersDescLabel = new Label(excludedComp, 0);
        excludedFoldersDescLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        excludedFoldersDescLabel.setText(Messages.EditorPreferencePage_GroupEditorAdvancedFeature_Excluded_List_Description);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public boolean performOk() {
        try {
            IPreferenceStore prefs = this.getPreferenceStore();
            prefs.setValue("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY", this.excludedFoldersText.getText());
            InstanceScope.INSTANCE.getNode("org.tizen.web.editor").flush();
        }
        catch (BackingStoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore prefs = this.getPreferenceStore();
        prefs.setValue("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY", "tau,tizen-web-ui-fw,tizen-ui-builder-fw,cultures,cowhide,lib,.build");
        this.excludedFoldersText.setText("tau,tizen-web-ui-fw,tizen-ui-builder-fw,cultures,cowhide,lib,.build");
        super.performDefaults();
    }

    public String getOldExcludedFoldersText() {
        return this.oldExcludedFoldersText;
    }

    public void setOldExcludedFoldersText(String oldExcludedFoldersText) {
        this.oldExcludedFoldersText = oldExcludedFoldersText;
    }
}

