/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.contentassist.proposals;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNamedNodeMap;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNodeList;
import org.eclipse.wst.css.ui.internal.image.CSSImageHelper;
import org.eclipse.wst.html.core.internal.document.DocumentStyleImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.MarkupCompletionProposal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.html.Activator;
import org.tizen.web.editor.html.HTMLAdvancedFeatureConstants;
import org.tizen.web.editor.html.HTMLEditor;
import org.tizen.web.editor.html.contentassist.proposals.HTMLTagsCompletionProposalComputerAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class HTMLTagsAttributeValueCompletionProposalComputer
extends HTMLTagsCompletionProposalComputerAdapter
implements HTMLAdvancedFeatureConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(contentAssistRequest.getRegion());
        if (i < 0) {
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
            return;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        if (nameRegion != null) {
            String tagName = node.getNodeName();
            if (tagName == null) {
                this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
                return;
            }
            String tagAttribute = open.getText(nameRegion);
            if (tagAttribute == null) {
                this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
                return;
            }
            tagName = tagName.toLowerCase();
            HTMLAdvancedFeatureConstants.HTMLTag htmlTag = HTMLAdvancedFeatureConstants.HTMLTag.getHTMLTag(tagName);
            tagAttribute = tagAttribute.toLowerCase();
            HTMLAdvancedFeatureConstants.HTMLTagAttribute htmlTagAttribute = HTMLAdvancedFeatureConstants.HTMLTagAttribute.getHTMLTagAttribute(tagAttribute);
            IEditorPart activeEditor = SWTUtil.getActiveEditor();
            IEditorInput editorInput = activeEditor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFile currentEditingFile = ((IFileEditorInput)editorInput).getFile();
                IProject project = currentEditingFile.getProject();
                WebResourceManager webResourceManager = new WebResourceManager(project, currentEditingFile);
                webResourceManager.makeProjectManagedResourceMap();
                int rOffset = contentAssistRequest.getReplacementBeginPosition();
                int rLength = contentAssistRequest.getReplacementLength();
                String matchString = contentAssistRequest.getMatchString();
                if (matchString.equals("")) {
                    this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
                    return;
                }
                matchString = matchString.substring(1);
                try {
                    this.makeTagAttributeProposals(activeEditor, contentAssistRequest, webResourceManager, htmlTag, htmlTagAttribute, matchString, rOffset, rLength);
                }
                catch (BadLocationException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                if (contentAssistRequest.getProposals() == null || contentAssistRequest.getProposals().size() < 1) {
                    this.setErrorMessage("No proposals.");
                }
            } else {
                this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
            }
        } else {
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
        }
    }

    private void makeTagAttributeProposals(IEditorPart activeEditor, ContentAssistRequest contentAssistRequest, WebResourceManager webResourceManager, HTMLAdvancedFeatureConstants.HTMLTag htmlTag, HTMLAdvancedFeatureConstants.HTMLTagAttribute htmlTagAttribute, String matchingString, int rOffset, int rLength) throws BadLocationException {
        switch (htmlTagAttribute) {
            case HREF: {
                if (htmlTag == HTMLAdvancedFeatureConstants.HTMLTag.A) {
                    this.makeIdProposal(activeEditor, contentAssistRequest, matchingString, rOffset, rLength);
                }
                this.makeFileProposals(contentAssistRequest, webResourceManager, htmlTag, matchingString, rOffset, rLength);
                break;
            }
            case SRC: {
                this.makeFileProposals(contentAssistRequest, webResourceManager, htmlTag, matchingString, rOffset, rLength);
                break;
            }
            case CLASS: 
            case ID: {
                this.makeSelectorProposal(contentAssistRequest, htmlTagAttribute, matchingString, rOffset, rLength);
                break;
            }
        }
    }

    private void makeFileProposals(ContentAssistRequest contentAssistRequest, WebResourceManager webResourceManager, HTMLAdvancedFeatureConstants.HTMLTag htmlTag, String matchingString, int rOffset, int rLength) {
        Map<String, IResource> foundResources = this.findMatchedResources(webResourceManager, htmlTag, matchingString);
        if (foundResources == null) {
            return;
        }
        Set<Map.Entry<String, IResource>> entrySet = foundResources.entrySet();
        for (Map.Entry<String, IResource> next : entrySet) {
            String filePath = next.getKey();
            if (filePath.equals("")) continue;
            IResource resource = next.getValue();
            Image image = this.getImage(htmlTag, resource);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String workspacePath = workspace.getRoot().getLocation().toString();
            String contentPath = String.valueOf(workspacePath) + resource.getFullPath();
            String content = null;
            switch (htmlTag) {
                case IMG: {
                    content = filePath;
                    break;
                }
                case A: 
                case IFRAME: {
                    content = this.readFile(contentPath, true);
                    break;
                }
                case LINK: 
                case SCRIPT: {
                    content = this.readFile(contentPath, false);
                    break;
                }
            }
            MarkupCompletionProposal proposal = new MarkupCompletionProposal(filePath, rOffset + 1, rLength - 2, filePath.length(), image, String.valueOf(resource.getName()) + "    (" + filePath + ")", filePath, null, content, 800, true);
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
        }
    }

    protected Image createCssImageDescriptor(String imageResourceName) {
        return CSSImageHelper.getInstance().getImage(imageResourceName);
    }

    private void makeIdProposal(IEditorPart activeEditor, ContentAssistRequest contentAssistRequest, String matchString, int rOffset, int rLength) throws BadLocationException {
        IDOMNode domNode = (IDOMNode)contentAssistRequest.getNode();
        Document ownerDocument = domNode.getOwnerDocument();
        Image idImage = this.createCssImageDescriptor("icons/full/tobj16/id_selector.png");
        List<Node> findElementHasIdAttribute = this.findElementHasIdAttribute(ownerDocument);
        for (Node node : findElementHasIdAttribute) {
            MarkupCompletionProposal proposal;
            IStructuredDocumentRegion startStructuredDocumentRegion = ((ElementStyleImpl)node).getStartStructuredDocumentRegion();
            int start = startStructuredDocumentRegion.getStart();
            String addtionalInfo = startStructuredDocumentRegion.getFullText();
            IDocument document = ((HTMLEditor)activeEditor).getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
            int lineOfOffset = document.getLineOfOffset(start);
            String idValue = ((ElementStyleImpl)node).getAttribute("id");
            if (matchString == null || matchString.trim().equals("") || matchString.trim().equals("#")) {
                proposal = new MarkupCompletionProposal("#" + idValue, rOffset + 1, rLength - 2, idValue.length() + 1, idImage, String.valueOf(idValue) + "    (" + (lineOfOffset + 1) + ")", node.getNodeName(), null, addtionalInfo, 800, true);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
                continue;
            }
            if (matchString.trim().startsWith("#")) {
                matchString = matchString.substring(1);
            }
            if (!idValue.startsWith(matchString)) continue;
            proposal = new MarkupCompletionProposal("#" + idValue, rOffset + 1, rLength - 2, idValue.length() + 1, idImage, String.valueOf(idValue) + "    (" + lineOfOffset + ")", node.getNodeName(), null, addtionalInfo, 800, true);
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
        }
    }

    private List<Node> findElementHasIdAttribute(Document document) {
        ArrayList<Node> hasIdAttributeElement = new ArrayList<Node>();
        NodeList childNodes = document.getChildNodes();
        if (childNodes.getLength() > 0) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (item instanceof ElementStyleImpl) {
                    this.findElementHasIdAttribute(item, hasIdAttributeElement);
                }
                ++i;
            }
        }
        return hasIdAttributeElement;
    }

    private List<Node> findElementHasIdAttribute(Node node, List<Node> hasIdAttributeElement) {
        if (node instanceof ElementStyleImpl) {
            String attribute;
            NodeList childNodes = node.getChildNodes();
            if (childNodes.getLength() > 0) {
                int i = 0;
                while (i < childNodes.getLength()) {
                    this.findElementHasIdAttribute(childNodes.item(i), hasIdAttributeElement);
                    ++i;
                }
            }
            if ((attribute = ((ElementStyleImpl)node).getAttribute("id")) != null && !attribute.trim().equals("")) {
                hasIdAttributeElement.add(node);
            }
        }
        return hasIdAttributeElement;
    }

    private void makeSelectorProposal(ContentAssistRequest contentAssistRequest, HTMLAdvancedFeatureConstants.HTMLTagAttribute tagAttribute, String matchString, int rOffset, int rLength) throws BadLocationException {
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        Image idImage = this.createCssImageDescriptor("icons/full/tobj16/id_selector.png");
        Image classImage = this.createCssImageDescriptor("icons/full/tobj16/class_selector.png");
        Document ownerDocument = node.getOwnerDocument();
        StyleSheetList styleSheets = ((DocumentStyleImpl)ownerDocument).getStyleSheets();
        if (styleSheets != null) {
            int numerOfStyleSheet = styleSheets.getLength();
            int j = 0;
            while (j < numerOfStyleSheet) {
                String filePath;
                StyleSheet styleSheet = styleSheets.item(j);
                if (styleSheet != null && (filePath = styleSheet.getHref()) != null && !filePath.trim().equals("")) {
                    int lastIndexOfFileSeparator = filePath.lastIndexOf("/");
                    filePath = filePath.substring(lastIndexOfFileSeparator + 1);
                    CSSNodeImpl css = (CSSNodeImpl)styleSheet;
                    IStructuredDocument document = ((ICSSDocument)css).getModel().getStructuredDocument();
                    ICSSNodeList childNodes = css.getChildNodes();
                    int numberOfChildNode = childNodes.getLength();
                    int index = 0;
                    while (index < numberOfChildNode) {
                        String selectorName;
                        CSSNodeImpl cssNode = (CSSNodeImpl)childNodes.item(index);
                        ICSSNamedNodeMap map = cssNode.getAttributes();
                        ICSSAttr attr = (ICSSAttr)map.item(0);
                        if (attr != null && (selectorName = attr.getValue()) != null && !selectorName.trim().equals("")) {
                            CSSNodeImpl ownerCSSNode = (CSSNodeImpl)attr.getOwnerCSSNode();
                            int offset = ownerCSSNode.getStartOffset();
                            int length = ownerCSSNode.getEndOffset() - offset;
                            String advancedInfo = document.get(offset, length);
                            advancedInfo = "<pre>" + advancedInfo + "</pre>";
                            StringTokenizer selectorNameTokenizer = new StringTokenizer(selectorName);
                            while (selectorNameTokenizer.hasMoreTokens()) {
                                String[] splitedSelectorTokens;
                                String selectorToken = selectorNameTokenizer.nextToken();
                                String[] stringArray = splitedSelectorTokens = selectorToken.split(",");
                                int n = splitedSelectorTokens.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MarkupCompletionProposal proposal;
                                    String selector = stringArray[n2];
                                    if (HTMLAdvancedFeatureConstants.HTMLTagAttribute.ID == tagAttribute) {
                                        if (selector != null && selector.startsWith("#")) {
                                            selector = selector.substring(1);
                                            if (matchString == null || matchString.trim().equals("") || selector.startsWith(matchString)) {
                                                proposal = new MarkupCompletionProposal(selector, rOffset + 1, rLength - 2, selector.length(), idImage, String.valueOf(selector) + "    (" + filePath + ")", selector, null, advancedInfo, 800, true);
                                                contentAssistRequest.addProposal((ICompletionProposal)proposal);
                                            }
                                        }
                                    } else if (HTMLAdvancedFeatureConstants.HTMLTagAttribute.CLASS == tagAttribute && selector != null && selector.startsWith(".")) {
                                        selector = selector.substring(1);
                                        if (matchString == null || matchString.trim().equals("") || selector.startsWith(matchString)) {
                                            proposal = new MarkupCompletionProposal(selector, rOffset + 1, rLength - 2, selector.length(), classImage, String.valueOf(selector) + "    (" + filePath + ")", selector, null, advancedInfo, 800, true);
                                            contentAssistRequest.addProposal((ICompletionProposal)proposal);
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        }
                        ++index;
                    }
                }
                ++j;
            }
        }
    }

    private Image getImage(HTMLAdvancedFeatureConstants.HTMLTag htmlTag, IResource resource) {
        Image image = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String workspacePath = workspace.getRoot().getLocation().toString();
        switch (htmlTag) {
            case LINK: {
                image = Activator.getImageDescriptor("icons/css_files.png").createImage();
                break;
            }
            case IMG: {
                image = new Image((Device)Display.getCurrent(), String.valueOf(workspacePath) + resource.getFullPath());
                image = this.resize(image, 16, 16);
                break;
            }
            case A: {
                image = Activator.getImageDescriptor("icons/html_file.png").createImage();
                break;
            }
            case IFRAME: {
                image = Activator.getImageDescriptor("icons/html_file.png").createImage();
                break;
            }
            case SCRIPT: {
                image = Activator.getImageDescriptor("icons/javascript_file.png").createImage();
                break;
            }
        }
        return image;
    }

    private Map<String, IResource> findMatchedStringResources(Map<String, IResource> resources, String matchingString) {
        HashMap<String, IResource> matchedResources = new HashMap<String, IResource>();
        Set<Map.Entry<String, IResource>> entrySet = resources.entrySet();
        for (Map.Entry<String, IResource> currentResource : entrySet) {
            String resourceKey = currentResource.getKey();
            IResource resourceValue = currentResource.getValue();
            String resourceName = resourceValue.getName();
            if (!resourceName.startsWith(matchingString)) continue;
            matchedResources.put(resourceKey, resourceValue);
        }
        if (matchedResources.size() == 0) {
            matchedResources = null;
        }
        return matchedResources;
    }

    private Map<String, IResource> findMatchedResources(WebResourceManager webResourceManager, HTMLAdvancedFeatureConstants.HTMLTag htmlTag, String matchingString) {
        Map<String, IResource> matchedResources = null;
        switch (htmlTag) {
            case LINK: {
                matchedResources = webResourceManager.getCssFiles();
                break;
            }
            case IMG: {
                matchedResources = webResourceManager.getImageFiles();
                break;
            }
            case A: {
                matchedResources = webResourceManager.getHtmlFiles();
                break;
            }
            case IFRAME: {
                matchedResources = webResourceManager.getHtmlFiles();
                break;
            }
            case SCRIPT: {
                matchedResources = webResourceManager.getJsFiles();
                break;
            }
        }
        if (matchedResources != null && matchingString != null && !matchingString.trim().equals("")) {
            matchedResources = this.findMatchedStringResources(matchedResources, matchingString);
        }
        return matchedResources;
    }

    private boolean isNotSupportedPreviewFile(String filePath) {
        long length;
        boolean isNotSupported = false;
        if (filePath.contains("tizen-web-ui-fw") || filePath.contains("tizen-ui-builder-fw")) {
            return true;
        }
        File file = new File(filePath);
        if (file.exists() && (length = file.length()) > 40960L) {
            isNotSupported = true;
        }
        return isNotSupported;
    }

    private String readFile(String filePath, boolean isHtml) {
        String content;
        block9: {
            content = "";
            if (filePath != null && this.isNotSupportedPreviewFile(filePath)) {
                content = "A Preview of this file is not supported.";
                return content;
            }
            FileInputStream ips = null;
            InputStreamReader ipsr = null;
            BufferedReader br = null;
            try {
                ips = new FileInputStream(filePath);
                ipsr = new InputStreamReader(ips);
                br = new BufferedReader(ipsr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (isHtml) {
                        line = line.replaceAll("<", "&lt;");
                        line = line.replaceAll(">", "&gt;");
                    }
                    content = String.valueOf(content) + "<pre>" + line + "</pre>" + "<br>";
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
                break block9;
            }
            catch (IOException e) {
                try {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
                break block9;
            }
            IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
        }
        return content;
    }

    private Image resize(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        image.dispose();
        return scaled;
    }
}

