/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util.jsconsole;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.console.IConsoleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.core.application.Version;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleManager;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleUtil;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public class JsLogConsoleFactory
implements IConsoleFactory {
    public static Logger logger = LoggerFactory.getLogger(JsLogConsoleFactory.class);
    private static HashMap<String, JsLogConsoleManager> consoleMap = new HashMap();
    private static boolean isListen = false;
    protected static FactoryWithArgument<JsLogConsoleManager, String> consoleManagerFactory = new FactoryWithArgument<JsLogConsoleManager, String>(){

        public JsLogConsoleManager create(String name) {
            return new JsLogConsoleManager(name, false);
        }
    };
    private static JsLogConsoleManager consoleManager;
    private IDevice device = null;

    public JsLogConsoleFactory(IDevice device) {
        this.device = device;
    }

    public void openConsole() {
        JsLogConsoleFactory.openJsLogConsole(null, this.device, "", new JsLogReceiver("", null), null, null);
    }

    public static JsLogConsoleManager createJsLogConsole(String name) {
        return (JsLogConsoleManager)((Object)consoleManagerFactory.create((Object)name));
    }

    public static void setConsoleManagerFactory(FactoryWithArgument<JsLogConsoleManager, String> factory) {
        consoleManagerFactory = factory;
    }

    public static void setConsoleMap(HashMap<String, JsLogConsoleManager> consoleMap) {
        JsLogConsoleFactory.consoleMap = consoleMap;
    }

    private static void addListener() {
        if (!isListen) {
            JsLogConsoleDeviceListener listner = new JsLogConsoleDeviceListener();
            SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)listner);
            isListen = true;
        }
    }

    public static void openJsLogConsole(IProject project, IDevice device, String packageID, JsLogReceiver receiver, String profile, Version version) {
        String name = JsLogConsoleUtil.getConsoleName(device);
        consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            JsLogConsoleFactory.genConsoleManager(name);
        }
        try {
            consoleManager.openConsole(project, device, packageID, receiver, profile, version);
        }
        catch (IOException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void clear(IDevice device) {
        JsLogConsoleManager consoleManager = JsLogConsoleFactory.getConsoleManager(device);
        if (consoleManager != null) {
            consoleManager.clear();
        }
    }

    public static JsLogConsoleManager getConsoleManager(IDevice device) {
        if (device == null) {
            return null;
        }
        String name = JsLogConsoleUtil.getConsoleName(device);
        consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            JsLogConsoleFactory.genConsoleManager(name);
        }
        return consoleManager;
    }

    private static void genConsoleManager(String name) {
        JsLogConsoleFactory.addListener();
        consoleManager = JsLogConsoleFactory.createJsLogConsole(name);
        consoleMap.put(name, consoleManager);
    }

    public static void closeJsLogConsole(IDevice device) {
        String name = JsLogConsoleUtil.getConsoleName(device);
        JsLogConsoleManager consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            return;
        }
        try {
            consoleManager.closeConsole();
        }
        catch (IOException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static class JsLogConsoleDeviceListener
    implements IDeviceChangeListener {
        private JsLogConsoleDeviceListener() {
        }

        public void onConnected(IDevice device) {
        }

        public void onChanged(IDevice device, int changeMask) {
        }

        public void onDisconnected(IDevice device) {
            if (device != null) {
                consoleMap.remove(JsLogConsoleUtil.getConsoleName(device));
                JsLogConsoleUtil.getConsoleManager().removeConsoles(JsLogConsoleUtil.getConsoles(device));
            }
        }
    }
}

