/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.validation;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.validation.ResourceResolver;
import org.tizen.web.editor.configuration.validation.XMLErrorHandler;
import org.xml.sax.SAXException;

public class SchemaBasedValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SIGN_SCHEMA = "signature_schema.xsd";
    public static final String SCHEMAS_PATH = String.valueOf(File.separator) + "schemas" + File.separator;
    public static final String SCHEMA_CONFIG_MARKER = "org.tizen.web.editor.configuration.problemmarker.xmlSchema";

    public void validateConfigurationDocument(IFile configFile) {
        try {
            IConfigurationElement[] ces;
            configFile.deleteMarkers(SCHEMA_CONFIG_MARKER, true, 2);
            TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)configFile.getProject());
            if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
                return;
            }
            String platformName = tizenDesc.getPlatformName();
            IConfigurationElement[] iConfigurationElementArray = ces = PluginUtil.getExtensionConfigurationElements((String)"org.tizen.web.editor.configuration");
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (platformName.equalsIgnoreCase(ce.getAttribute("platform"))) {
                    this.validateConfigurationDocument(configFile, ce.getAttribute("schema"));
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void validateConfigurationDocument(IFile configFile, String schemaFileNames) {
        try {
            configFile.deleteMarkers(SCHEMA_CONFIG_MARKER, true, 2);
            TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)configFile.getProject());
            if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
                return;
            }
            String rootSchemaFilePath = String.valueOf(tizenDesc.getPlatformInfo().getPlatformPath(tizenDesc.getVersion())) + SCHEMAS_PATH + schemaFileNames;
            this.logger.trace("SchemaFile: " + rootSchemaFilePath);
            File file = new File(rootSchemaFilePath);
            if (file.exists()) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setResourceResolver(new ResourceResolver(configFile.getProject()));
                Schema schema = factory.newSchema(new StreamSource(file));
                StreamSource source = new StreamSource(configFile.getLocation().toFile());
                Validator validator = schema.newValidator();
                validator.setErrorHandler(new XMLErrorHandler(configFile));
                validator.validate(source);
            } else {
                this.logger.error("Invalid file or path: " + rootSchemaFilePath);
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

