/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.model;

import org.eclipse.swt.graphics.Color;
import org.tizen.web.unittest.resultview.model.IWUTResultTreeElement;
import org.tizen.web.unittest.resultview.style.StyledString;

public abstract class WUTResultParent
implements IWUTResultTreeElement {
    private String name;
    protected int totalAssertionCount;
    protected int failedAssertionCount;
    protected long elapsedTime;

    public WUTResultParent(String name, int total, int failed, long time) {
        this.name = name;
        this.totalAssertionCount = total;
        this.failedAssertionCount = failed;
        this.elapsedTime = time;
    }

    public String getName() {
        return this.name;
    }

    public int getTotalAssertionCount() {
        return this.totalAssertionCount;
    }

    public void addTotalAssertionCount(int count) {
        this.totalAssertionCount += count;
    }

    public int getFailedAssertionCount() {
        return this.failedAssertionCount;
    }

    public void addFailedAssertionCount(int count) {
        this.failedAssertionCount += count;
    }

    public void addElapsedTime(long time) {
        this.elapsedTime += time;
    }

    public boolean hasFailure() {
        return this.failedAssertionCount > 0;
    }

    @Override
    public StyledString getDetail() {
        Color color = this.failedAssertionCount > 0 ? StyledString.failedColor : StyledString.okayColor;
        StyledString styledString = new StyledString("Tests completed in " + this.elapsedTime + " milliseconds.\n" + (this.totalAssertionCount - this.failedAssertionCount) + " assertions of " + this.totalAssertionCount + " passed, " + this.failedAssertionCount + " failed.", color);
        return styledString;
    }
}

