/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.project.model.SourceProject;
import org.tizen.common.project.util.ProjectValidationUtil;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.ui.wizards.imports.AbstractDoAfterImport;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.extension.ITemplateContributor;
import org.tizen.web.project.wizard.extension.ITemplateOptionControl;
import org.tizen.web.project.wizard.extension.WebProjectCreator;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;
import org.tizen.web.project.wizard.operation.ContentAssistOperation;
import org.tizen.web.project.wizard.operation.DefaultNatureOperation;
import org.tizen.web.project.wizard.operation.IProjectTemplateOperation;

public class WebDoAfterImport
extends AbstractDoAfterImport {
    public boolean isSupportedDirectory(String path) {
        return this.isSupportedDirectory(path, "config.xml");
    }

    public boolean isSupportedPackage(String path) {
        return this.isSupportedPackage(path, "config.xml");
    }

    public List<String> getSupportedPackageFilter() {
        ArrayList<String> filterList = new ArrayList<String>();
        filterList.add("*.wgt");
        return filterList;
    }

    public String validateProjectName(String projectName) {
        if (!ProjectValidationUtil.isValidName((String)projectName)) {
            return "Project name is invalid.";
        }
        return null;
    }

    public String[] getFilesToBeExcluded(SourceProject srcProj) {
        String sourceProjectName;
        String sourcePackageName = sourceProjectName = new File(srcProj.getPath()).getName();
        if (!srcProj.isPackage()) {
            sourcePackageName = String.valueOf(sourcePackageName) + ".wgt";
        }
        String[] filterList = new String[]{sourcePackageName, SignatureUtility.getAuthorFilename(), SignatureUtility.getDistributorFilename((int)1), SignatureUtility.getDistributorFilename((int)2)};
        return filterList;
    }

    public boolean performImport(SourceProject srcProj, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            monitor.beginTask("Web import", 100);
            String toMigration = srcProj.getPlatformToCreate();
            String profile = srcProj.getProfileFrom(toMigration);
            String version = srcProj.getVersionFrom(toMigration);
            Collection<IProjectTemplateOperation> operations = this.getProjectTemplateOperations(toMigration);
            for (IProjectTemplateOperation operation : operations) {
                if (operation.execute(null, project, null)) continue;
                throw new OperationCanceledException();
            }
            monitor.worked(50);
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            if (natures == null) {
                return false;
            }
            String[] stringArray = natures;
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                if ("org.tizen.webuibuilder.nature".equals(nature)) {
                    ITemplateContributor contributor = this.getUIBuilderContributeExtension();
                    if (contributor == null) break;
                    contributor.doAfter(project, new ITemplateOptionControl[0]);
                    break;
                }
                ++n2;
            }
            monitor.worked(30);
            WebProjectCreator creator = new WebProjectCreator(project);
            creator.initializeConfigurationForImport(profile, version, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            return true;
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.project.wizard", e.getMessage(), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private IProjectTemplateOperation getMigrateOperation(final String toMigration) {
        AbstractProjectTemplateOperation migrateOperation = new AbstractProjectTemplateOperation(){

            @Override
            public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
                ProfileInfo profileInfo = WebDoAfterImport.this.getProfileInfo(toMigration);
                if (profileInfo != null) {
                    ProjectUtil.updateTizenProjectDescription((IProject)project, (ProfileInfo)profileInfo);
                }
                return true;
            }
        };
        migrateOperation.setMainTask(WizardMessages.WebProjectMigrationWizardPage_ProgressTask);
        return migrateOperation;
    }

    protected Collection<IProjectTemplateOperation> getProjectTemplateOperations(String toMigration) {
        IProjectTemplateOperation migrateOperation = this.getMigrateOperation(toMigration);
        LinkedList<IProjectTemplateOperation> operations = new LinkedList<IProjectTemplateOperation>();
        operations.add(migrateOperation);
        operations.add(new DefaultNatureOperation());
        operations.add(migrateOperation);
        operations.add(new ContentAssistOperation());
        return operations;
    }

    private ProfileInfo getProfileInfo(String platform) {
        for (ProfileInfo info : InstallPathConfig.flattenPlatformPathInfos()) {
            if (!platform.equals(info.getLatestPlatformName())) continue;
            return info;
        }
        return null;
    }

    private ITemplateContributor getUIBuilderContributeExtension() throws CoreException {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = reg.getConfigurationElementsFor("org.tizen.web.project.templates");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("template".equals(element.getName())) {
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("contributeTemplate");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object obj;
                    IConfigurationElement childElement = iConfigurationElementArray2[n4];
                    String type = childElement.getAttribute("type");
                    if (type != null && type.equalsIgnoreCase("UIBuilder") && (obj = childElement.createExecutableExtension("class")) instanceof ITemplateContributor) {
                        return (ITemplateContributor)obj;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean performAfterImport(String selectedProfile, String selectedVersion, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask("Web project is importing", 100);
        try {
            String[] natures;
            String platform = this.getPlatform(selectedProfile, selectedVersion);
            Collection<IProjectTemplateOperation> operations = this.getProjectTemplateOperations(platform);
            for (IProjectTemplateOperation operation : operations) {
                if (operation.execute(null, project, null)) continue;
                throw new OperationCanceledException();
            }
            monitor.worked(50);
            IProjectDescription description = project.getDescription();
            String[] stringArray = natures = description.getNatureIds();
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                if (nature.equals("org.tizen.webuibuilder.nature")) {
                    ITemplateContributor contributor = this.getUIBuilderContributeExtension();
                    if (contributor == null) break;
                    contributor.doAfter(project, new ITemplateOptionControl[0]);
                    break;
                }
                ++n2;
            }
            monitor.worked(30);
            WebProjectCreator creator = new WebProjectCreator(project);
            creator.initializeConfigurationForImport(selectedProfile, selectedVersion, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            return true;
        }
        catch (ConfigurationException e) {
            String errorMsg = String.valueOf(WizardMessages.WEB_IMPORT_ERROR) + (e.getMessage() != null ? e.getMessage() : (e.getCause() != null ? e.getCause().getMessage() : ""));
            this.logger.error(errorMsg, (Throwable)e);
            DialogUtil.openErrorDialog((String)errorMsg);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private String getPlatform(String profile, String version) {
        return String.valueOf(profile) + "-" + version;
    }
}

