/*
 * Decompiled with CFR 0.152.
 */
package json.outline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import json.model.jsonnode.JsonNode;
import json.model.jsonnode.JsonType;
import json.outline.node.JsonTreeNode;

public class JsonModelOutlineParser {
    public JsonTreeNode parse(List<JsonNode> jsonNodes) {
        if (jsonNodes == null) {
            return null;
        }
        JsonTreeNode root = null;
        JsonTreeNode parent = null;
        for (JsonNode jsonNode : jsonNodes) {
            if (this.isNodeOfType(jsonNode, JsonType.End)) {
                if (parent == null) continue;
                parent = parent.getParent();
                continue;
            }
            JsonTreeNode treeNode = new JsonTreeNode(jsonNode, parent);
            if (root == null) {
                parent = root = treeNode;
            } else {
                if (parent == null) {
                    parent = root;
                }
                parent.addChild(treeNode);
            }
            if (!this.isNodeOfType(jsonNode, JsonType.Object, JsonType.Array)) continue;
            parent = treeNode;
        }
        return root;
    }

    public JsonTreeNode mergeNodes(JsonTreeNode oldRootObject, List<JsonNode> jsonNodes) {
        if (jsonNodes == null) {
            return oldRootObject;
        }
        if (oldRootObject == null && jsonNodes != null) {
            return this.parse(jsonNodes);
        }
        JsonTreeNode root = oldRootObject;
        JsonTreeNode parent = null;
        JsonTreeNode head = root;
        ArrayList<Integer> childIterStack = new ArrayList<Integer>();
        try {
            Integer childIter = 0;
            for (JsonNode jsonNode : jsonNodes) {
                if (this.isNodeOfType(jsonNode, JsonType.End)) {
                    LinkedList<JsonTreeNode> nodesToRemove = new LinkedList<JsonTreeNode>();
                    if (parent != null) {
                        while (childIter < parent.getChildren().size()) {
                            head = parent.getChildren().get(childIter);
                            nodesToRemove.add(head);
                            childIter = childIter + 1;
                        }
                    }
                    for (JsonTreeNode nodeToRemove : nodesToRemove) {
                        nodeToRemove.removeFromParent();
                    }
                    childIter = childIterStack.size() > 0 ? (Integer)childIterStack.remove(0) : Integer.valueOf(root.getChildren().size());
                    if (parent == null || (parent = parent.getParent()) != null) continue;
                    parent = root;
                    continue;
                }
                if (parent != null && childIter < parent.getChildren().size()) {
                    head = parent.getChildren().get(childIter);
                    childIter = childIter + 1;
                } else if (head != root || head == root && parent != null) {
                    head = null;
                }
                if (head == null) {
                    head = new JsonTreeNode(jsonNode, parent);
                    parent.addChild(head);
                    childIter = childIter + 1;
                }
                if (!jsonNode.equals(head.getJsonNode())) {
                    head.setJsonNode(jsonNode);
                }
                if (this.isNodeOfType(jsonNode, JsonType.Object, JsonType.Array)) {
                    parent = head;
                    childIterStack.add(0, childIter);
                    childIter = 0;
                    continue;
                }
                if (!head.hasChildren()) continue;
                head.clearChildren();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    private boolean isNodeOfType(JsonNode jsonNode, JsonType ... jsonTypes) {
        JsonType[] jsonTypeArray = jsonTypes;
        int n = jsonTypes.length;
        int n2 = 0;
        while (n2 < n) {
            JsonType jsonType = jsonTypeArray[n2];
            if (jsonNode.getJsonType() == jsonType) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

