/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.webwidget.validator.core;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.ResourceUtil;

public class ValidatedIssue {
    private final String fileName;
    private final int line;
    private final int postion;
    private final char severity;
    private final String message;

    public ValidatedIssue(String fileName, int line, int postion, char severity, String message) {
        this.fileName = fileName;
        this.line = line;
        this.postion = postion;
        this.severity = severity;
        this.message = message;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public int getPostion() {
        return this.postion;
    }

    public char getSeverity() {
        return this.severity;
    }

    public int getBuildInfoSeverity() {
        return this.severity == 'W' ? 1 : 2;
    }

    public String getMessage() {
        return this.message;
    }

    public org.tizen.common.file.IResource getResource(String projectLocation) {
        if (projectLocation != null) {
            File file = new File(String.valueOf(projectLocation) + File.separator + this.fileName);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
            return ResourceUtil.convertResource((IResource)iFile);
        }
        return null;
    }

    public String toString() {
        return "ResultItem [fileName=" + this.fileName + ", line=" + this.line + ", postion=" + this.postion + ", severity=" + this.severity + ", message=" + this.message + "]";
    }
}

