/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.contentassist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaNoTypeCompletionProposalComputer;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.contentassist.HTMLCompletionProposalComputer;
import org.tizen.web.editor.javascript.contentassist.StringLiteralCompletionProposal;
import org.tizen.web.editor.javascript.util.JavaScriptEditorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringLiteralCompletionProposalComputer
extends JavaNoTypeCompletionProposalComputer
implements JavaScriptEditorConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String fErrorMessage;
    private ITypeRoot javaScriptCompilationUnit;
    private ASTNode rootASTNode = null;
    private ASTNode completionNodeParent = null;
    private ASTNode completionStringLiteral = null;
    private int argumentPosition = -1;
    private ReceiverNode receiver = null;
    private IEditorPart activeEditor = null;
    private String astNodeFoundString = null;
    protected XMLContentModelGenerator fGenerator;

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        this.activeEditor = SWTUtil.getActiveEditor();
        if (this.activeEditor == null) {
            return Collections.EMPTY_LIST;
        }
        this.initCompletionNode();
        IFileEditorInput jsFileEditorInput = (IFileEditorInput)this.activeEditor.getEditorInput();
        IFile jsFile = jsFileEditorInput.getFile();
        this.javaScriptCompilationUnit = (ITypeRoot)JavaScriptUI.getEditorInputJavaElement((IEditorInput)jsFileEditorInput);
        this.rootASTNode = JavaScriptEditorUtil.parseJavaScript((ICompilationUnit)this.javaScriptCompilationUnit);
        if (this.rootASTNode == null) {
            return Collections.EMPTY_LIST;
        }
        final int currentPosition = context.getInvocationOffset();
        this.rootASTNode.accept(new ASTVisitor(){

            public boolean visit(StringLiteral stringLiteral) {
                int start = stringLiteral.getStartPosition();
                int end = start + stringLiteral.getLength();
                if (start <= currentPosition && currentPosition <= end) {
                    ASTNode parent = stringLiteral.getParent();
                    if (parent != null && parent.getNodeType() == 32) {
                        StringLiteralCompletionProposalComputer.this.completionNodeParent = parent;
                        StringLiteralCompletionProposalComputer.this.completionStringLiteral = (ASTNode)stringLiteral;
                        List arguments = ((FunctionInvocation)parent).arguments();
                        if (arguments != null && arguments.size() > 0) {
                            int i = 0;
                            while (i < arguments.size()) {
                                ASTNode argument = (ASTNode)arguments.get(i);
                                int startPosition = argument.getStartPosition();
                                int length = argument.getLength();
                                if (currentPosition >= startPosition && currentPosition <= startPosition + length) {
                                    Expression expression = ((FunctionInvocation)parent).getExpression();
                                    if (expression != null && expression instanceof SimpleName) {
                                        StringLiteralCompletionProposalComputer.this.receiver = new ReceiverNode(0, ((SimpleName)expression).getIdentifier(), (ASTNode)expression);
                                    } else if (expression != null && expression instanceof FunctionInvocation) {
                                        StringLiteralCompletionProposalComputer.this.receiver = new ReceiverNode(1, expression.toString(), (ASTNode)expression);
                                    }
                                    StringLiteralCompletionProposalComputer.this.argumentPosition = i;
                                    break;
                                }
                                ++i;
                            }
                        }
                    } else if (parent != null && parent.getNodeType() == 27) {
                        StringLiteralCompletionProposalComputer.this.completionNodeParent = parent.getParent();
                        StringLiteralCompletionProposalComputer.this.completionStringLiteral = (ASTNode)stringLiteral;
                    } else if (parent != null && parent.getNodeType() == 7) {
                        StringLiteralCompletionProposalComputer.this.completionNodeParent = parent;
                        StringLiteralCompletionProposalComputer.this.completionStringLiteral = (ASTNode)stringLiteral;
                    }
                    return false;
                }
                return true;
            }
        });
        if (this.completionNodeParent != null) {
            JavaScriptEditorConstants.AdvanceStringLiteralCompletionType foundProperCompletionType = this.findProperCompletionType(this.completionNodeParent, this.completionStringLiteral);
            return this.getProposals(foundProperCompletionType, jsFile, currentPosition, this.completionStringLiteral);
        }
        return Collections.EMPTY_LIST;
    }

    private void initCompletionNode() {
        this.fErrorMessage = null;
        this.completionNodeParent = null;
        this.completionStringLiteral = null;
    }

    private JavaScriptEditorConstants.AdvanceStringLiteralCompletionType findProperCompletionType(ASTNode completionNodeParent, ASTNode currentCompletionNode) {
        String identifier;
        SimpleName simpleName;
        Expression leftHandSide;
        if (completionNodeParent instanceof FunctionInvocation) {
            SimpleName simpleName2 = ((FunctionInvocation)completionNodeParent).getName();
            if (simpleName2 == null) {
                return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
            }
            String identifier2 = simpleName2.getIdentifier();
            if (identifier2 == null || identifier2.trim().equals("")) {
                return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
            }
            String escapedValue = ((StringLiteral)currentCompletionNode).getEscapedValue();
            if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
                escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
            } else if (escapedValue == null) {
                escapedValue = "";
            }
            if (identifier2 != null) {
                if (identifier2.equals("getElementById")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.ID;
                }
                if (identifier2.equals("getElementsByName")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NAME;
                }
                if (identifier2.equals("getElementsByTagName")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.TAG;
                }
                if (identifier2.equals("createElement")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.TAG_ALL;
                }
                if (identifier2.equals("addEventListener") || identifier2.equals("removeEventListener")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.EVENT_TYPE;
                }
                if (identifier2.equals("createAttribute")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.ATTRIBUTE_ALL;
                }
                if (identifier2.equals("setAttribute") || identifier2.equals("getAttribute") || identifier2.equals("getAttributeNode") || identifier2.equals("hasAttribute") || identifier2.equals("removeAttribute")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.ATTRIBUTE;
                }
                if (identifier2.equals("querySelector") || identifier2.equals("$")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.QUERY_SELECTOR;
                }
                if (identifier2.equals("innerHTML") || identifier2.equals("html") || identifier2.equals("append") || identifier2.equals("prepend") || identifier2.equals("after") || identifier2.equals("before")) {
                    if (this.argumentPosition != 0) {
                        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
                    }
                    return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.LANGUAGE_MIXING_EDIT;
                }
            }
        } else if (completionNodeParent instanceof Assignment && (leftHandSide = ((Assignment)completionNodeParent).getLeftHandSide()) instanceof FieldAccess && (simpleName = ((FieldAccess)leftHandSide).getName()) != null && (identifier = simpleName.getIdentifier()) != null && identifier.equals("innerHTML")) {
            return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.LANGUAGE_MIXING_EDIT;
        }
        return JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.NONE;
    }

    private List<ICompletionProposal> getProposals(JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType, IFile file, int offset, ASTNode completionNode) {
        WebResourceManager resourceManager = new WebResourceManager(file.getProject());
        resourceManager.makeProjectManagedResourceMap();
        Map htmlFiles = resourceManager.getHtmlFiles();
        List<IFile> foundHtmls = JavaScriptEditorUtil.findLinkedHtml(htmlFiles, file.getFullPath().toString());
        if (foundHtmls == null || foundHtmls.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        List<ICompletionProposal> proposals = null;
        proposals = new ArrayList<ICompletionProposal>();
        if (foundHtmls.size() > 0) {
            switch (properCompletionType) {
                case QUERY_SELECTOR: {
                    proposals = this.getQuerySelectorProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case ID: {
                    proposals = this.getIdProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case CLASS: {
                    proposals = this.getClassProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case NAME: {
                    proposals = this.getNameProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case HTML: {
                    proposals = this.getHtmlProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case TAG: {
                    proposals = this.getTagProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case TAG_ALL: {
                    proposals = this.getAllTagProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case EVENT_TYPE: {
                    proposals = this.getEventTypeProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case ATTRIBUTE_ALL: {
                    proposals = this.getCreateAttributeProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case ATTRIBUTE: {
                    proposals = this.getAttributeProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
                case LANGUAGE_MIXING_EDIT: {
                    proposals = this.getHtmlCodeProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
                    break;
                }
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> getHtmlCodeProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        HTMLCompletionProposalComputer htmlCompletionProposalComputer;
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        String escapedValueFirstCharacter = null;
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValueFirstCharacter = escapedValue.startsWith("'") ? "'" : "\"";
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        if (!(htmlCompletionProposalComputer = new HTMLCompletionProposalComputer((IJavaCompletionProposalComputer)this)).validateRequest(offset, completionNode)) {
            return Collections.EMPTY_LIST;
        }
        String matchingString = htmlCompletionProposalComputer.getMatchingString(escapedValue, completionNode, offset);
        if (matchingString != null) {
            escapedValue = matchingString;
        }
        if (this.completionNodeParent instanceof Assignment) {
            String identifier;
            SimpleName simpleName;
            Expression leftOperand = ((Assignment)this.completionNodeParent).getLeftHandSide();
            if (leftOperand instanceof FieldAccess && (simpleName = ((FieldAccess)leftOperand).getName()) != null && (identifier = simpleName.getIdentifier()) != null && identifier.equals("innerHTML")) {
                Expression leftOperandExpression = ((FieldAccess)leftOperand).getExpression();
                if (leftOperandExpression != null && leftOperandExpression instanceof SimpleName) {
                    this.receiver = new ReceiverNode(0, ((SimpleName)leftOperandExpression).getIdentifier(), (ASTNode)leftOperandExpression);
                } else if (leftOperandExpression != null && leftOperandExpression instanceof FunctionInvocation) {
                    this.receiver = new ReceiverNode(1, leftOperandExpression.toString(), (ASTNode)leftOperandExpression);
                }
                this.makeHTMLProposal(proposals, foundHtmls, htmlCompletionProposalComputer, escapedValue, escapedValueFirstCharacter, offset);
            }
        } else if (this.completionNodeParent instanceof FunctionInvocation) {
            this.makeHTMLProposal(proposals, foundHtmls, htmlCompletionProposalComputer, escapedValue, escapedValueFirstCharacter, offset);
        }
        return proposals;
    }

    private void makeHTMLProposal(List<ICompletionProposal> proposals, List<IFile> foundHtmls, HTMLCompletionProposalComputer htmlCompletionProposalComputer, String escapedValue, String escapedValueFirstCharacter, int offset) {
        try {
            IFile file = foundHtmls.get(0);
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
            if (model != null) {
                NodeList elementsByTagName;
                IDOMDocument document = ((DOMStyleModelImpl)model).getDocument();
                ElementStyleImpl foundNode = this.findNodeFromReceiverNode(this.receiver, document);
                if (foundNode == null && (elementsByTagName = document.getElementsByTagName("html")) != null && elementsByTagName.getLength() > 0) {
                    foundNode = (ElementStyleImpl)elementsByTagName.item(0);
                }
                if (foundNode != null) {
                    proposals = htmlCompletionProposalComputer.getHTMLProposals(proposals, foundNode, model, escapedValue, escapedValueFirstCharacter, offset);
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<ICompletionProposal> getNameProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        int i = 0;
        while (i < foundHtmls.size()) {
            try {
                IDOMDocument document;
                List<ElementStyleImpl> elementsHaveNameAttribute;
                IFile file = foundHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null && (elementsHaveNameAttribute = JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(document = ((DOMStyleModelImpl)model).getDocument(), "name")).size() > 0) {
                    for (ElementStyleImpl element : elementsHaveNameAttribute) {
                        String nameValue;
                        JavaCompletionProposal proposal = null;
                        String tagName = element.getNodeName();
                        String replaceString = nameValue = element.getAttribute("name");
                        int replaceOffset = offset;
                        int replaceLength = nameValue.length();
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement((Node)element);
                        if (escapedValue != null && !escapedValue.trim().equals("")) {
                            if (!replaceString.startsWith(escapedValue)) continue;
                            proposal = new JavaCompletionProposal(replaceString, replaceOffset - escapedValue.length(), replaceLength, JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), String.valueOf(replaceString) + " (" + file.getName() + " : " + lineOfOffset + " - " + tagName + ")", 99);
                            proposals.add((ICompletionProposal)proposal);
                            continue;
                        }
                        proposal = new JavaCompletionProposal(replaceString, replaceOffset, replaceLength, JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), String.valueOf(replaceString) + " (" + file.getName() + " : " + lineOfOffset + " - " + tagName + ")", 99);
                        proposals.add((ICompletionProposal)proposal);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return proposals;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void setErrorMessage(String fErrorMessage) {
        this.fErrorMessage = fErrorMessage;
    }

    private List<ICompletionProposal> getQuerySelectorProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        if (escapedValue != null && escapedValue.startsWith("#")) {
            proposals = this.getIdProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
        } else if (escapedValue != null && escapedValue.startsWith(".")) {
            proposals = this.getClassProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
        } else {
            proposals = this.getIdProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
            proposals = this.getClassProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
            proposals = this.getTagProposals(proposals, foundHtmls, offset, completionNode, properCompletionType);
        }
        return proposals;
    }

    private List<ICompletionProposal> getIdProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        boolean isIdSelectorPrefix = false;
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        if (escapedValue != null && escapedValue.startsWith("#")) {
            escapedValue = escapedValue.substring(1);
            isIdSelectorPrefix = true;
        }
        int i = 0;
        while (i < foundHtmls.size()) {
            try {
                IDOMDocument document;
                List<ElementStyleImpl> elementsHaveIdAttribute;
                IFile file = foundHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null && (elementsHaveIdAttribute = JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(document = ((DOMStyleModelImpl)model).getDocument(), "id")).size() > 0) {
                    for (ElementStyleImpl element : elementsHaveIdAttribute) {
                        String idValue;
                        StringLiteralCompletionProposal proposal = null;
                        String tagName = element.getNodeName();
                        String replaceString = idValue = element.getAttribute("id");
                        int replaceOffset = offset;
                        int replaceLength = idValue.length();
                        if (properCompletionType == JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.QUERY_SELECTOR) {
                            replaceString = "#" + idValue;
                            replaceLength = idValue.length() + 1;
                        }
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement((Node)element);
                        String compareEscapedValue = escapedValue;
                        if (escapedValue != null && !escapedValue.trim().equals("")) {
                            if (properCompletionType == JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.QUERY_SELECTOR) {
                                compareEscapedValue = "#" + compareEscapedValue;
                                replaceOffset = isIdSelectorPrefix ? replaceOffset - escapedValue.length() - 1 : (replaceOffset -= escapedValue.length());
                            } else {
                                replaceOffset -= escapedValue.length();
                            }
                            if (!replaceString.startsWith(compareEscapedValue)) continue;
                            proposal = new StringLiteralCompletionProposal(replaceString, replaceOffset, replaceLength, JavaScriptEditorUtil.createImageDescriptor("css", "icons/full/tobj16/id_selector.png"), String.valueOf(idValue) + " (" + file.getName() + " : " + lineOfOffset + " - " + tagName + ")", 99);
                            proposals.add((ICompletionProposal)proposal);
                            continue;
                        }
                        if (isIdSelectorPrefix) {
                            --replaceOffset;
                        }
                        proposal = new StringLiteralCompletionProposal(replaceString, replaceOffset, replaceLength, JavaScriptEditorUtil.createImageDescriptor("css", "icons/full/tobj16/id_selector.png"), String.valueOf(idValue) + " (" + file.getName() + " : " + lineOfOffset + " - " + tagName + ")", 99);
                        proposals.add((ICompletionProposal)proposal);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return proposals;
    }

    private List<ICompletionProposal> getClassProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        boolean isClassSelectorPrefix = false;
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        if (escapedValue != null && escapedValue.startsWith(".")) {
            escapedValue = escapedValue.substring(1);
            isClassSelectorPrefix = true;
        }
        int i = 0;
        while (i < foundHtmls.size()) {
            try {
                IDOMDocument document;
                List<ElementStyleImpl> elementsHaveClassAttribute;
                IFile file = foundHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null && (elementsHaveClassAttribute = JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(document = ((DOMStyleModelImpl)model).getDocument(), "class")).size() > 0) {
                    for (ElementStyleImpl element : elementsHaveClassAttribute) {
                        String classValue;
                        StringLiteralCompletionProposal proposal = null;
                        String tagName = element.getNodeName();
                        String replaceString = classValue = element.getAttribute("class");
                        int replaceOffset = offset;
                        int replaceLength = classValue.length();
                        if (properCompletionType == JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.QUERY_SELECTOR) {
                            replaceString = "." + classValue;
                            replaceLength = classValue.length() + 1;
                        }
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement((Node)element);
                        String compareEscapedValue = escapedValue;
                        if (escapedValue != null && !escapedValue.trim().equals("")) {
                            if (properCompletionType == JavaScriptEditorConstants.AdvanceStringLiteralCompletionType.QUERY_SELECTOR) {
                                compareEscapedValue = "." + compareEscapedValue;
                                replaceOffset = isClassSelectorPrefix ? replaceOffset - escapedValue.length() - 1 : (replaceOffset -= escapedValue.length());
                            } else {
                                replaceOffset -= escapedValue.length();
                            }
                            if (!replaceString.startsWith(compareEscapedValue)) continue;
                            proposal = new StringLiteralCompletionProposal(replaceString, replaceOffset, replaceLength, JavaScriptEditorUtil.createImageDescriptor("css", "icons/full/tobj16/class_selector.png"), String.valueOf(classValue) + " (" + file.getName() + " : " + lineOfOffset + " - " + tagName + ")", 99);
                            proposals.add((ICompletionProposal)proposal);
                            continue;
                        }
                        if (isClassSelectorPrefix) {
                            --replaceOffset;
                        }
                        proposal = new StringLiteralCompletionProposal(replaceString, replaceOffset, replaceLength, JavaScriptEditorUtil.createImageDescriptor("css", "icons/full/tobj16/class_selector.png"), String.valueOf(classValue) + " (" + file.getName() + " : " + lineOfOffset + " - " + tagName + ")", 99);
                        proposals.add((ICompletionProposal)proposal);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return proposals;
    }

    private List<ICompletionProposal> getHtmlProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        try {
            IDOMDocument document;
            NodeList elementsByTagName;
            IFile file = foundHtmls.get(0);
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
            if (model != null && (elementsByTagName = (document = ((DOMStyleModelImpl)model).getDocument()).getElementsByTagName("html")) != null && elementsByTagName.getLength() > 0) {
                CMElementDeclaration cmElementDeclaration;
                List availableContent;
                ElementStyleImpl htmlNode = (ElementStyleImpl)elementsByTagName.item(0);
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                if (modelQuery != null && (availableContent = modelQuery.getAvailableContent((Element)htmlNode, cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)htmlNode), 255)) != null) {
                    String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
                    if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
                        escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
                    }
                    JavaCompletionProposal proposal = null;
                    int i = 0;
                    while (i < availableContent.size()) {
                        Object object = availableContent.get(i);
                        if (object instanceof CMElementDeclaration) {
                            CMElementDeclaration element = (CMElementDeclaration)object;
                            String nodeName = element.getNodeName();
                            nodeName = nodeName.toLowerCase();
                            if (escapedValue != null && !escapedValue.trim().equals("")) {
                                if (nodeName.startsWith(escapedValue = escapedValue.toLowerCase())) {
                                    proposal = new JavaCompletionProposal(nodeName, offset - escapedValue.length(), nodeName.length(), JavaScriptEditorUtil.createImageDescriptor("html", "icons/full/tobj16/tag.png"), nodeName, 99);
                                    proposals.add((ICompletionProposal)proposal);
                                }
                            } else {
                                proposal = new JavaCompletionProposal(nodeName, offset, nodeName.length(), JavaScriptEditorUtil.createImageDescriptor("html", "icons/full/tobj16/tag.png"), nodeName, 99);
                                proposals.add((ICompletionProposal)proposal);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return proposals;
    }

    private List<ICompletionProposal> getTagProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        int i = 0;
        while (i < foundHtmls.size()) {
            try {
                IFile file = foundHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null) {
                    IDOMDocument document = ((DOMStyleModelImpl)model).getDocument();
                    List<ElementStyleImpl> elements = JavaScriptEditorUtil.getElements(document);
                    JavaCompletionProposal proposal = null;
                    int j = 0;
                    while (j < elements.size()) {
                        ElementStyleImpl node = elements.get(j);
                        String nodeName = node.getNodeName();
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement((Node)node);
                        if (escapedValue != null && !escapedValue.trim().equals("")) {
                            if (nodeName.startsWith(escapedValue = escapedValue.toLowerCase())) {
                                proposal = new JavaCompletionProposal(nodeName, offset - escapedValue.length(), nodeName.length(), JavaScriptEditorUtil.createImageDescriptor("html", "icons/full/tobj16/tag.png"), String.valueOf(nodeName) + " (" + file.getName() + " : " + lineOfOffset + ")", 99);
                                proposals.add((ICompletionProposal)proposal);
                            }
                        } else {
                            proposal = new JavaCompletionProposal(nodeName, offset, nodeName.length(), JavaScriptEditorUtil.createImageDescriptor("html", "icons/full/tobj16/tag.png"), String.valueOf(nodeName) + " (" + file.getName() + " : " + lineOfOffset + ")", 99);
                            proposals.add((ICompletionProposal)proposal);
                        }
                        ++j;
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return proposals;
    }

    private List<ICompletionProposal> getAllTagProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        try {
            IDOMDocument document;
            NodeList elementsByTagName;
            String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
            if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
                escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
            }
            IFile file = foundHtmls.get(0);
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
            if (model != null && (elementsByTagName = (document = ((DOMStyleModelImpl)model).getDocument()).getElementsByTagName("html")) != null && elementsByTagName.getLength() > 0) {
                CMElementDeclaration cmElementDeclaration;
                List availableContent;
                ElementStyleImpl htmlNode = (ElementStyleImpl)elementsByTagName.item(0);
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                if (modelQuery != null && (availableContent = modelQuery.getAvailableContent((Element)htmlNode, cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)htmlNode), 255)) != null) {
                    JavaCompletionProposal proposal = null;
                    int i = 0;
                    while (i < availableContent.size()) {
                        Object object = availableContent.get(i);
                        if (object instanceof CMElementDeclaration) {
                            CMElementDeclaration element = (CMElementDeclaration)object;
                            String nodeName = element.getNodeName();
                            nodeName = nodeName.toLowerCase();
                            if (escapedValue != null && !escapedValue.trim().equals("")) {
                                if (nodeName.startsWith(escapedValue = escapedValue.toLowerCase())) {
                                    proposal = new JavaCompletionProposal(nodeName, offset - escapedValue.length(), nodeName.length(), JavaScriptEditorUtil.createImageDescriptor("html", "icons/full/tobj16/tag.png"), nodeName, 99);
                                    proposals.add((ICompletionProposal)proposal);
                                }
                            } else {
                                proposal = new JavaCompletionProposal(nodeName, offset, nodeName.length(), JavaScriptEditorUtil.createImageDescriptor("html", "icons/full/tobj16/tag.png"), nodeName, 99);
                                proposals.add((ICompletionProposal)proposal);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return proposals;
    }

    private List<ICompletionProposal> getEventTypeProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        try {
            IDOMDocument document;
            NodeList elementsByTagName;
            IFile file = foundHtmls.get(0);
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
            if (model != null && (elementsByTagName = (document = ((DOMStyleModelImpl)model).getDocument()).getElementsByTagName("html")) != null && elementsByTagName.getLength() > 0) {
                CMElementDeclaration cmElementDeclaration;
                CMNamedNodeMap attributes;
                ElementStyleImpl htmlNode = (ElementStyleImpl)elementsByTagName.item(0);
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                if (modelQuery != null && (attributes = (cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)htmlNode)).getAttributes()) != null) {
                    String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
                    if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
                        escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
                        escapedValue = escapedValue.toLowerCase();
                    }
                    JavaCompletionProposal proposal = null;
                    int i = 0;
                    while (i < attributes.getLength()) {
                        CMNode attribute = attributes.item(i);
                        String attributeName = attribute.getNodeName();
                        if (attributeName != null && !attributeName.trim().equals("") && (attributeName = attributeName.toLowerCase()).startsWith("on")) {
                            attributeName = attributeName.substring(2);
                            if (escapedValue != null && !escapedValue.trim().equals("")) {
                                if (attributeName.startsWith(escapedValue = escapedValue.toLowerCase())) {
                                    proposal = new JavaCompletionProposal(attributeName, offset - escapedValue.length(), attributeName.length(), JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), attributeName, 99);
                                    proposals.add((ICompletionProposal)proposal);
                                }
                            } else {
                                proposal = new JavaCompletionProposal(attributeName, offset, attributeName.length(), JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), attributeName, 99);
                                proposals.add((ICompletionProposal)proposal);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return proposals;
    }

    private List<ICompletionProposal> getCreateAttributeProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        try {
            IDOMDocument document;
            NodeList elementsByTagName;
            IFile file = foundHtmls.get(0);
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
            if (model != null && (elementsByTagName = (document = ((DOMStyleModelImpl)model).getDocument()).getElementsByTagName("html")) != null && elementsByTagName.getLength() > 0) {
                CMElementDeclaration cmElementDeclaration;
                CMNamedNodeMap attributes;
                ElementStyleImpl htmlNode = (ElementStyleImpl)elementsByTagName.item(0);
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                if (modelQuery != null && (attributes = (cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)htmlNode)).getAttributes()) != null) {
                    JavaCompletionProposal proposal = null;
                    int i = 0;
                    while (i < attributes.getLength()) {
                        CMNode attribute = attributes.item(i);
                        String attributeName = attribute.getNodeName();
                        if (attributeName != null && !attributeName.trim().equals("")) {
                            attributeName = attributeName.toLowerCase();
                            if (escapedValue != null && !escapedValue.trim().equals("")) {
                                if (attributeName.startsWith(escapedValue = escapedValue.toLowerCase())) {
                                    proposal = new JavaCompletionProposal(attributeName, offset - escapedValue.length(), attributeName.length(), JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), attributeName, 99);
                                    proposals.add((ICompletionProposal)proposal);
                                }
                            } else {
                                proposal = new JavaCompletionProposal(attributeName, offset, attributeName.length(), JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), attributeName, 99);
                                proposals.add((ICompletionProposal)proposal);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return proposals;
    }

    private List<ICompletionProposal> getAttributeProposals(List<ICompletionProposal> proposals, List<IFile> foundHtmls, int offset, ASTNode completionNode, JavaScriptEditorConstants.AdvanceStringLiteralCompletionType properCompletionType) {
        String escapedValue = ((StringLiteral)completionNode).getEscapedValue();
        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
        }
        try {
            IFile file = foundHtmls.get(0);
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
            if (model != null) {
                IDOMDocument document = ((DOMStyleModelImpl)model).getDocument();
                if (this.receiver != null) {
                    CMElementDeclaration cmElementDeclaration;
                    CMNamedNodeMap attributes;
                    ElementStyleImpl foundNode = this.findNodeFromReceiverNode(this.receiver, document);
                    if (foundNode == null) {
                        return proposals;
                    }
                    ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                    if (modelQuery != null && (attributes = (cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)foundNode)).getAttributes()) != null) {
                        JavaCompletionProposal proposal = null;
                        int i = 0;
                        while (i < attributes.getLength()) {
                            CMNode attribute = attributes.item(i);
                            String attributeName = attribute.getNodeName();
                            if (attributeName != null && !attributeName.trim().equals("")) {
                                attributeName = attributeName.toLowerCase();
                                if (escapedValue != null && !escapedValue.trim().equals("")) {
                                    if (attributeName.startsWith(escapedValue = escapedValue.toLowerCase())) {
                                        proposal = new JavaCompletionProposal(attributeName, offset - escapedValue.length(), attributeName.length(), JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), attributeName, 99);
                                        proposals.add((ICompletionProposal)proposal);
                                    }
                                } else {
                                    proposal = new JavaCompletionProposal(attributeName, offset, attributeName.length(), JavaScriptEditorUtil.createImageDescriptor("xml", "icons/full/tobj16/attribute_obj.png"), attributeName, 99);
                                    proposals.add((ICompletionProposal)proposal);
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return proposals;
    }

    public ElementStyleImpl findNodeFromReceiverNode(ReceiverNode receiver, IDOMDocument document) {
        if (receiver.type == 0) {
            IBinding resolvedBinding = ((Name)receiver.receiverNode).resolveBinding();
            if (resolvedBinding instanceof IVariableBinding) {
                ASTNode foundDeclaringNode = ((JavaScriptUnit)this.rootASTNode).findDeclaringNode(resolvedBinding.getKey());
                if (foundDeclaringNode == null) {
                    return null;
                }
                String foundNodeString = foundDeclaringNode.toString();
                int startPosition = foundNodeString.indexOf("\"");
                int lastPosition = -1;
                if (startPosition == -1) {
                    startPosition = foundNodeString.indexOf("'");
                    lastPosition = foundNodeString.lastIndexOf("'");
                } else {
                    lastPosition = foundNodeString.lastIndexOf("\"");
                }
                if (startPosition != -1) {
                    String value = foundNodeString.substring(startPosition + 1, lastPosition);
                    if (value == null) {
                        return null;
                    }
                    if (foundNodeString.contains("$") && value.startsWith("#")) {
                        value = value.substring(1);
                        return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", value);
                    }
                    if (foundNodeString.contains("$") && value.startsWith(".")) {
                        value = value.substring(1);
                        return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "class", value);
                    }
                    if (foundNodeString.contains("$")) {
                        NodeList elementsByTagName = document.getElementsByTagName(value);
                        if (elementsByTagName != null && elementsByTagName.getLength() > 0) {
                            return (ElementStyleImpl)elementsByTagName.item(0);
                        }
                        return null;
                    }
                    return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", value);
                }
                startPosition = foundNodeString.indexOf("(");
                lastPosition = foundNodeString.lastIndexOf(")");
                if (startPosition != -1) {
                    final String variableName = foundNodeString.substring(startPosition + 1, lastPosition).trim();
                    this.rootASTNode.accept(new ASTVisitor(){

                        public void preVisit(ASTNode node) {
                            String escapedValue;
                            Expression initializer;
                            String nodeText;
                            if (node instanceof VariableDeclarationFragment && (nodeText = ((VariableDeclarationFragment)node).toString().trim()) != null && nodeText.startsWith(variableName) && (initializer = ((VariableDeclarationFragment)node).getInitializer()) instanceof StringLiteral && (escapedValue = ((StringLiteral)initializer).getEscapedValue()) != null && (escapedValue.startsWith("\"") || escapedValue.startsWith("'"))) {
                                StringLiteralCompletionProposalComputer.this.astNodeFoundString = escapedValue.substring(1, escapedValue.length() - 1);
                            }
                        }
                    });
                    if (this.astNodeFoundString != null) {
                        if (this.astNodeFoundString == null) {
                            return null;
                        }
                        if (foundNodeString.contains("$") && this.astNodeFoundString.startsWith("#")) {
                            this.astNodeFoundString = this.astNodeFoundString.substring(1);
                            return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", this.astNodeFoundString);
                        }
                        if (foundNodeString.contains("$") && this.astNodeFoundString.startsWith(".")) {
                            this.astNodeFoundString = this.astNodeFoundString.substring(1);
                            return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "class", this.astNodeFoundString);
                        }
                        if (foundNodeString.contains("$")) {
                            NodeList elementsByTagName = document.getElementsByTagName(this.astNodeFoundString);
                            if (elementsByTagName != null && elementsByTagName.getLength() > 0) {
                                return (ElementStyleImpl)elementsByTagName.item(0);
                            }
                            return null;
                        }
                        return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", this.astNodeFoundString);
                    }
                }
            }
        } else {
            String receiverString = receiver.receiverString;
            int startPosition = receiverString.indexOf("\"");
            int lastPosition = -1;
            if (startPosition == -1) {
                startPosition = receiverString.indexOf("'");
                lastPosition = receiverString.lastIndexOf("'");
            } else {
                lastPosition = receiverString.lastIndexOf("\"");
            }
            if (startPosition != -1) {
                String value = receiverString.substring(startPosition + 1, lastPosition);
                if (value == null) {
                    return null;
                }
                if (receiverString.startsWith("$") && value.startsWith("#")) {
                    value = value.substring(1);
                    return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", value);
                }
                if (receiverString.startsWith("$") && value.startsWith(".")) {
                    value = value.substring(1);
                    return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "class", value);
                }
                if (receiverString.startsWith("$")) {
                    NodeList elementsByTagName = document.getElementsByTagName(value);
                    if (elementsByTagName != null && elementsByTagName.getLength() > 0) {
                        return (ElementStyleImpl)elementsByTagName.item(0);
                    }
                    return null;
                }
                return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", value);
            }
            startPosition = receiverString.indexOf("(");
            lastPosition = receiverString.lastIndexOf(")");
            if (startPosition != -1) {
                final String variableName = receiverString.substring(startPosition + 1, lastPosition).trim();
                this.rootASTNode.accept(new ASTVisitor(){

                    public void preVisit(ASTNode node) {
                        String escapedValue;
                        Expression initializer;
                        String nodeText;
                        if (node instanceof VariableDeclarationFragment && (nodeText = ((VariableDeclarationFragment)node).toString().trim()) != null && nodeText.startsWith(variableName) && (initializer = ((VariableDeclarationFragment)node).getInitializer()) instanceof StringLiteral && (escapedValue = ((StringLiteral)initializer).getEscapedValue()) != null && (escapedValue.startsWith("\"") || escapedValue.startsWith("'"))) {
                            StringLiteralCompletionProposalComputer.this.astNodeFoundString = escapedValue.substring(1, escapedValue.length() - 1);
                        }
                    }
                });
                if (this.astNodeFoundString != null) {
                    if (this.astNodeFoundString == null) {
                        return null;
                    }
                    if (receiverString.startsWith("$") && this.astNodeFoundString.startsWith("#")) {
                        this.astNodeFoundString = this.astNodeFoundString.substring(1);
                        return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", this.astNodeFoundString);
                    }
                    if (receiverString.startsWith("$") && this.astNodeFoundString.startsWith(".")) {
                        this.astNodeFoundString = this.astNodeFoundString.substring(1);
                        return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "class", this.astNodeFoundString);
                    }
                    if (receiverString.startsWith("$")) {
                        NodeList elementsByTagName = document.getElementsByTagName(this.astNodeFoundString);
                        if (elementsByTagName != null && elementsByTagName.getLength() > 0) {
                            return (ElementStyleImpl)elementsByTagName.item(0);
                        }
                        return null;
                    }
                    return JavaScriptEditorUtil.getElemenGivenAttributeNameAndValue(document, "id", this.astNodeFoundString);
                }
            }
        }
        return null;
    }

    static class ReceiverNode {
        int type;
        String receiverString;
        ASTNode receiverNode;

        ReceiverNode(int type, String receiverString, ASTNode receiverNode) {
            this.type = type;
            this.receiverString = receiverString;
            this.receiverNode = receiverNode;
        }
    }
}

