/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.navigation;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.navigation.SymbolInformation;

public class SymbolNavigatorLabelProvider
extends DecoratingJavaLabelProvider
implements JavaScriptEditorConstants {
    private ILabelProvider labelProvider = null;

    public SymbolNavigatorLabelProvider(JavaUILabelProvider labelProvider) {
        super(labelProvider);
        this.labelProvider = labelProvider;
    }

    public Image getImage(Object element) {
        IJavaScriptElement matchingElement;
        IJavaScriptElement javaScriptElement;
        Image image = null;
        if (element instanceof SymbolInformation && (javaScriptElement = ((SymbolInformation)element).getJavaScriptElement()) instanceof ITypeRoot && (matchingElement = this.getMatchingElement((SymbolInformation)element)) != null) {
            image = this.labelProvider.getImage((Object)matchingElement);
        }
        return image;
    }

    public String getText(Object element) {
        String className;
        String labelText = null;
        labelText = element instanceof SymbolInformation ? ((className = ((SymbolInformation)element).getClassName()) != null && !className.equals("") ? String.valueOf(((SymbolInformation)element).getSymbolName()) + " (" + ((SymbolInformation)element).getFile().getName() + " - " + className + " : " + ((SymbolInformation)element).getSymbolLine() + ")" : String.valueOf(((SymbolInformation)element).getSymbolName()) + " (" + ((SymbolInformation)element).getFile().getName() + " : " + ((SymbolInformation)element).getSymbolLine() + ")") : "";
        return labelText;
    }

    private IJavaScriptElement getMatchingElement(SymbolInformation symbolInformation) {
        IJavaScriptElement foundElement;
        block9: {
            foundElement = null;
            String symbolName = symbolInformation.getSymbolName();
            if (symbolName == null) {
                return foundElement;
            }
            IJavaScriptElement javaScriptElement = symbolInformation.getJavaScriptElement();
            if (javaScriptElement != null && javaScriptElement instanceof ITypeRoot) {
                try {
                    IJavaScriptElement[] children = null;
                    if (javaScriptElement instanceof IClassFile) {
                        children = ((IClassFile)javaScriptElement).getChildren();
                    } else if (javaScriptElement instanceof IJavaScriptUnit) {
                        children = ((IJavaScriptUnit)javaScriptElement).getChildren();
                    }
                    if (children == null || children.length <= 0) break block9;
                    IJavaScriptElement[] iJavaScriptElementArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaScriptElement child = iJavaScriptElementArray[n2];
                        foundElement = this.getMatchingElement(symbolInformation, child);
                        if (foundElement == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return foundElement;
    }

    private IJavaScriptElement getMatchingElement(SymbolInformation symbolInformation, IJavaScriptElement javaScriptElement) throws JavaScriptModelException {
        IJavaScriptElement foundElement = null;
        ASTNode astNode = symbolInformation.getAstNode();
        String searchSymbolName = symbolInformation.getSymbolName();
        String elementName = javaScriptElement.getElementName();
        if (javaScriptElement instanceof SourceType || javaScriptElement instanceof SourceMethod || javaScriptElement instanceof SourceField) {
            if (astNode instanceof FunctionDeclaration) {
                if (javaScriptElement instanceof SourceType || javaScriptElement instanceof SourceMethod && searchSymbolName.equals(elementName)) {
                    foundElement = javaScriptElement;
                    return foundElement;
                }
            } else if (searchSymbolName.equals(elementName)) {
                foundElement = javaScriptElement;
                return foundElement;
            }
            IJavaScriptElement[] children = null;
            if (javaScriptElement instanceof SourceType) {
                children = ((SourceType)javaScriptElement).getChildren();
            } else if (javaScriptElement instanceof SourceMethod) {
                children = ((SourceMethod)javaScriptElement).getChildren();
            } else if (javaScriptElement instanceof SourceField) {
                children = ((SourceField)javaScriptElement).getChildren();
            }
            if (children != null && children.length > 0) {
                IJavaScriptElement[] iJavaScriptElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaScriptElement child = iJavaScriptElementArray[n2];
                    foundElement = this.getMatchingElement(symbolInformation, child);
                    if (foundElement != null) break;
                    ++n2;
                }
            }
        }
        return foundElement;
    }
}

