/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.webwidget.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.error.BuildErrorInfo;
import org.tizen.common.builder.error.Location;
import org.tizen.common.file.IResource;
import org.tizen.common.util.FileUtil;
import org.tizen.web.webwidget.validator.core.ValidatedIssue;
import org.tizen.web.webwidget.validator.util.ValidatorUtil;

public class JSValidatorChecker {
    protected final Logger logger = LoggerFactory.getLogger(JSValidatorChecker.class);
    protected int severity = 2;
    private static JSValidatorChecker instance;

    public static JSValidatorChecker getInstance() {
        if (instance == null) {
            instance = new JSValidatorChecker();
        }
        return instance;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Collection<BuildErrorInfo> jsValidate(IProject project, IResource res, IProgressMonitor monitor) {
        Collection<ValidatedIssue> issues = this.runJSValidator(project, res, monitor);
        if (issues == null) {
            return null;
        }
        HashSet<BuildErrorInfo> buildErrInfos = new HashSet<BuildErrorInfo>();
        for (ValidatedIssue issue : issues) {
            Location location = new Location(issue.getResource(project.getLocation().toString()), issue.getLine(), -1);
            BuildErrorInfo info = new BuildErrorInfo(location, issue.getBuildInfoSeverity(), issue.getMessage());
            buildErrInfos.add(info);
        }
        return buildErrInfos;
    }

    private Collection<ValidatedIssue> runJSValidator(IProject project, IResource res, IProgressMonitor monitor) {
        IFile validateFile = project.getFile(res.getPath());
        project.getLocation();
        if (res == null) {
            this.logger.error("There are no resources to build");
            return null;
        }
        if (project == null) {
            this.logger.error("There is no project to build");
            return null;
        }
        if (validateFile == null || !validateFile.exists()) {
            return null;
        }
        return this.runJSValidator(project, false, monitor);
    }

    private Collection<ValidatedIssue> runJSValidator(IProject project, boolean isBuildErrorInfo, IProgressMonitor monitor) {
        String projectLocation = String.valueOf(project.getLocation().toString()) + File.separator + "widget" + File.separator + project.getName();
        if (!FileUtil.isExist((String)projectLocation)) {
            return null;
        }
        HashMap<String, ArrayList<ValidatedIssue>> vIssueMap = ValidatorUtil.executeWithFolder(projectLocation, monitor);
        if (vIssueMap == null) {
            return null;
        }
        ArrayList<ValidatedIssue> vIssueResults = null;
        Set<String> keys = vIssueMap.keySet();
        if (isBuildErrorInfo) {
            for (String key : keys) {
                ArrayList<ValidatedIssue> item = vIssueMap.get(key);
                if (vIssueResults == null) {
                    vIssueResults = vIssueMap.get(key);
                    continue;
                }
                vIssueResults.addAll(item);
            }
        } else {
            try {
                for (String key : keys) {
                    vIssueResults = vIssueMap.get(key);
                    IPath filepath = new Path(projectLocation).append(key);
                    IFile markingFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(filepath);
                    markingFile.deleteMarkers("org.tizen.webwidget.builder.marker.validator", true, 0);
                    for (ValidatedIssue r : vIssueResults) {
                        IMarker marker = markingFile.createMarker("org.tizen.webwidget.builder.marker.validator");
                        marker.setAttribute("message", (Object)r.getMessage());
                        marker.setAttribute("lineNumber", r.getLine());
                        marker.setAttribute("severity", r.getSeverity() == 'E' ? 2 : 1);
                    }
                    vIssueResults = null;
                }
            }
            catch (CoreException ce) {
                this.logger.error(ce.getMessage(), (Throwable)ce);
            }
        }
        return vIssueResults;
    }
}

