/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.internal.forms.MessageManager;
import org.tizen.web.editor.configuration.Messages;

public class MsgManagerWrapper {
    private ArrayList<Message> messages = new ArrayList();
    private Form form;
    private MessageManager messageManager;
    private Label notiRegion;
    private static final String MsgManager_sMessageSummary = "(1 Message)";
    private static final String MsgManager_sWarningSummary = "(1 Warning)";
    private static final String MsgManager_sErrorSummary = "(1 Error)";
    private static final String MsgManager_pMessageSummary = "({0} Messages)";
    private static final String MsgManager_pWarningSummary = "({0} Warnings)";
    private static final String MsgManager_pErrorSummary = "({0} Errors)";
    private static final String[] SINGLE_MSG_SUMMARY_KEYS = new String[]{"(1 Message)", "(1 Message)", "(1 Warning)", "(1 Error)"};
    private static final String[] MULTIPLE_MSG_SUMMARY_KEYS = new String[]{"({0} Messages)", "({0} Messages)", "({0} Warnings)", "({0} Errors)"};

    public MsgManagerWrapper(Form form) {
        this.form = form;
        this.messageManager = new MessageManager(form);
    }

    public void setNoticeRegion(Label notiRegion) {
        this.notiRegion = notiRegion;
    }

    public void addMessage(String prefix, Object key, String messageText, Object data, int type, Control control) {
        if (control == null) {
            this.messageManager.addMessage(key, messageText, data, type);
        } else {
            this.messageManager.addMessage(key, messageText, data, type, control);
        }
        this.addMessage(prefix, key, messageText, data, type, this.messages);
        this.updateNotice();
    }

    private Message addMessage(String prefix, Object key, String messageText, Object data, int type, ArrayList<Message> list) {
        Message message = this.findMessage(key, list);
        if (message == null) {
            message = new Message(key, messageText, type, data, prefix);
            list.add(message);
        } else {
            message.message = messageText;
            message.type = type;
            message.data = data;
            message.prefix = prefix;
        }
        return message;
    }

    public void removeMessage(Object key, Control control) {
        if (control == null) {
            this.messageManager.removeMessage(key);
        } else {
            this.messageManager.removeMessage(key, control);
        }
        Message message = this.findMessage(key, this.messages);
        if (message != null) {
            this.messages.remove(message);
            this.updateNotice();
        }
    }

    public void removeMessages() {
        this.messageManager.removeMessages();
        if (!this.messages.isEmpty()) {
            this.messages.clear();
            this.updateNotice();
        }
    }

    private Message findMessage(Object key, ArrayList<Message> list) {
        int i = 0;
        while (i < list.size()) {
            Message message = list.get(i);
            if (message.getKey().equals(key)) {
                return message;
            }
            ++i;
        }
        return null;
    }

    private void updateNotice() {
        if (this.notiRegion == null || this.notiRegion.isDisposed()) {
            return;
        }
        if (this.messages.isEmpty() || this.messages == null) {
            this.notiRegion.setText("");
            this.notiRegion.setToolTipText(null);
            return;
        }
        ArrayList<Message> peers = this.createPeers(this.messages);
        int maxType = ((IMessage)peers.get(0)).getMessageType();
        String messageText = "";
        messageText = peers.size() > 1 ? Messages.bind((String)MULTIPLE_MSG_SUMMARY_KEYS[maxType], (Object[])new String[]{String.valueOf(peers.size())}) : SINGLE_MSG_SUMMARY_KEYS[maxType];
        switch (maxType) {
            case 3: {
                this.notiRegion.setForeground(this.form.getDisplay().getSystemColor(3));
                break;
            }
            case 2: {
                this.notiRegion.setForeground(this.form.getDisplay().getSystemColor(8));
                break;
            }
            default: {
                this.notiRegion.setForeground(this.form.getDisplay().getSystemColor(2));
            }
        }
        this.notiRegion.setText(messageText);
        this.notiRegion.setToolTipText(this.createDetails(this.messages, false));
    }

    private static String getFullMessage(IMessage message) {
        if (message.getPrefix() == null) {
            return message.getMessage();
        }
        return String.valueOf(message.getPrefix()) + ": " + message.getMessage();
    }

    private ArrayList<Message> createPeers(ArrayList<Message> messages) {
        ArrayList<Message> peers = new ArrayList<Message>();
        int maxType = 0;
        int i = 0;
        while (i < messages.size()) {
            Message message = messages.get(i);
            if (message.type > maxType) {
                peers.clear();
                maxType = message.type;
            }
            if (message.type == maxType) {
                peers.add(message);
            }
            ++i;
        }
        return peers;
    }

    private String createDetails(ArrayList<Message> messages, boolean excludePrefix) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        int i = 0;
        while (i < messages.size()) {
            if (i > 0) {
                out.println();
            }
            IMessage m = messages.get(i);
            out.print(excludePrefix ? m.getMessage() : MsgManagerWrapper.getFullMessage(m));
            ++i;
        }
        out.flush();
        return sw.toString();
    }

    static class Message
    implements IMessage {
        Control control;
        Object data;
        Object key;
        String message;
        int type;
        String prefix;

        Message(Object key, String message, int type, Object data, String prefix) {
            this.key = key;
            this.message = message;
            this.type = type;
            this.data = data;
            this.prefix = prefix;
        }

        public Object getKey() {
            return this.key;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }

        public Control getControl() {
            return this.control;
        }

        public Object getData() {
            return this.data;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Message)) {
                return false;
            }
            Message msg = (Message)obj;
            return (msg.getPrefix() == null ? this.getPrefix() == null : msg.getPrefix().equals(this.getPrefix())) && (msg.getControl() == null ? this.getControl() == null : msg.getControl().equals(this.getControl())) && msg.getMessageType() == this.getMessageType() && (msg.getMessage() == null ? this.getMessage() == null : msg.getMessage().equals(this.getMessage())) && msg.getKey().equals(this.getKey());
        }
    }
}

