/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.atsc;

import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.atsc.ATSCStyle;
import org.w3c.css.properties.atsc.CssBorderTopColorATSC;
import org.w3c.css.properties.atsc.CssBorderTopStyleATSC;
import org.w3c.css.properties.atsc.CssBorderTopWidthATSC;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class CssBorderTopATSC
extends CssProperty
implements CssOperator {
    CssBorderTopWidthATSC width;
    CssBorderTopStyleATSC style;
    CssBorderTopColorATSC color;

    public CssBorderTopATSC() {
    }

    public CssBorderTopATSC(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssValue val = null;
        char op = ' ';
        boolean find = true;
        if (check2 && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        boolean manyValues = expression.getCount() > 1;
        this.setByUser();
        while (find) {
            find = false;
            val = expression.getValue();
            op = expression.getOperator();
            if (val == null) break;
            if (manyValues && val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", null, null, ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            if (this.width == null) {
                try {
                    this.width = new CssBorderTopWidthATSC(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.style == null) {
                try {
                    this.style = new CssBorderTopStyleATSC(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (find || this.color != null) continue;
            this.color = new CssBorderTopColorATSC(ac, expression);
            find = true;
        }
    }

    public CssBorderTopATSC(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public Object get() {
        return this.width;
    }

    public CssValue getColor() {
        if (this.color != null) {
            return this.color.getColor();
        }
        return null;
    }

    public CssValue getWidth() {
        if (this.width != null) {
            return this.width.getValue();
        }
        return null;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style.getStyle();
        }
        return null;
    }

    @Override
    public String toString() {
        String ret = "";
        if (this.width != null) {
            ret = ret + this.width;
        }
        if (this.style != null) {
            if (!ret.equals("")) {
                ret = ret + " ";
            }
            ret = ret + this.style;
        }
        if (this.color != null) {
            if (!ret.equals("")) {
                ret = ret + " ";
            }
            ret = ret + this.color;
        }
        return ret;
    }

    @Override
    public String getPropertyName() {
        return "border-top";
    }

    @Override
    public void setImportant() {
        if (this.width != null) {
            this.width.setImportant();
        }
        if (this.style != null) {
            this.style.setImportant();
        }
        if (this.color != null) {
            this.color.setImportant();
        }
    }

    @Override
    public boolean getImportant() {
        return !(this.width != null && !this.width.getImportant() || this.style != null && !this.style.getImportant() || this.color != null && !this.color.getImportant());
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        if (this.width != null) {
            this.width.addToStyle(ac, style);
        }
        if (this.style != null) {
            this.style.addToStyle(ac, style);
        }
        if (this.color != null) {
            this.color.addToStyle(ac, style);
        }
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ATSCStyle)style).getBorderTopATSC();
        }
        return ((ATSCStyle)style).cssBorderATSC.getTop();
    }

    @Override
    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.width != null) {
            this.width.setInfo(line, source);
        }
        if (this.style != null) {
            this.style.setInfo(line, source);
        }
        if (this.color != null) {
            this.color.setInfo(line, source);
        }
    }

    @Override
    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.width != null) {
            this.width.setSelectors(selector);
        }
        if (this.style != null) {
            this.style.setSelectors(selector);
        }
        if (this.color != null) {
            this.color.setSelectors(selector);
        }
    }

    @Override
    public boolean equals(CssProperty property) {
        if (property instanceof CssBorderTopATSC) {
            CssBorderTopATSC top = (CssBorderTopATSC)property;
            return this.width.equals(top.width) && this.style.equals(top.style) && this.color.equals(top.color);
        }
        return false;
    }

    void check() {
        if (this.style != null && this.style.face.value == 0 && this.width != null) {
            this.width.face.value = new CssLength();
        }
    }
}

