/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public interface WebFileRefactoringConstants {
    public static final String FILE_RENAME_REFACTORING = "tizen-web-file-rename-refactoring";
    public static final String FILE_MOVE_REFACTORING = "tizen-web-file-move-refactoring";
    public static final String FILE_DELETE_REFACTORING = "tizen-web-file-delete-refactoring";
    public static final String TAG_NAME_ANCHOR = "a";
    public static final String TAG_NAME_IFRAME = "iframe";
    public static final String TAG_NAME_LINK = "link";
    public static final String TAG_NAME_SCRIPT = "script";
    public static final String TAG_NAME_IMAGE = "img";
    public static final String ATTRIBUTE_NAME_HREF = "href";
    public static final String ATTRIBUTE_NAME_SRC = "src";
    public static final String CONSOLE_MESSAGE_PREFIX_RENAME = "[RENAME REFACTOR] ";
    public static final String CONSOLE_MESSAGE_PREFIX_MOVE = "[MOVE REFACTOR] ";
    public static final String CONSOLE_MESSAGE_PREFIX_DELETE = "[DELETE REFACTOR] ";
    public static final String CONSOLE_MESSAGE_DESC = " is changed at '";
    public static final String CONSOLE_MESSAGE_POSTFIX = "'.";
    public static final String CONSOLE_MESSAGE_COMMENT_PREFIX = "<!--";
    public static final String CONSOLE_MESSAGE_COMMENT_POSTFIX = "-->";
    public static final String OPEN_BRACE = "(";
    public static final String CLOSE_BRACE = ")";
    public static final String EMPTY_STRING = "";

    public static enum FileExtension {
        UNKNOWN(0, "No refactoring resources."),
        HTML(1, "html"),
        HTM(2, "htm"),
        JS(3, "js"),
        CSS(4, "css"),
        IMAGE(5, "image");

        private int code;
        private String name;
        private static final Map<String, FileExtension> lookup;

        static {
            lookup = new HashMap<String, FileExtension>();
            for (FileExtension extension : EnumSet.allOf(FileExtension.class)) {
                lookup.put(extension.getName(), extension);
            }
        }

        private FileExtension(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public static FileExtension getFileExtension(String extension) {
            return lookup.get(extension);
        }

        public boolean isImage(String extension) {
            boolean isImage = false;
            if ((extension = extension.toLowerCase()).equals("png") || extension.equals("jpg") || extension.equals("jpeg") || extension.equals("gif") || extension.equals("ico")) {
                isImage = true;
            }
            return isImage;
        }
    }
}

