/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.tizen.web.localization.ui.Messages;

public class NonLocalizedFileListSelectionDialog
extends ListSelectionDialog {
    private static final String OPEN_BUTTON_TEXT = Messages.NonLocalizedFileListSelectionDialog_0;
    private static final int OPEN_BUTTON_ID = 1025;
    private Button fOpenButton;

    public NonLocalizedFileListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        super(parentShell, input, contentProvider, labelProvider, message);
        this.setTitle(Messages.NonLocalizedFileListSelectionDialog_1);
        Object[] obj = contentProvider.getElements(input);
        if (obj != null) {
            this.setMessage(String.format("%d non-localized file(s) found. ", new Integer(obj.length)));
        }
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(-1, -1, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (NonLocalizedFileListSelectionDialog.this.fOpenButton != null) {
                    NonLocalizedFileListSelectionDialog.this.fOpenButton.setEnabled(!NonLocalizedFileListSelectionDialog.this.getViewer().getSelection().isEmpty());
                }
            }
        });
        this.getViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getViewer().getTable().setFocus();
        NonLocalizedFileListSelectionDialog.applyDialogFont((Control)result);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOpenButton = this.createButton(parent, 1025, OPEN_BUTTON_TEXT, true);
        this.fOpenButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId != 1025) {
            super.buttonPressed(buttonId);
            return;
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        StringBuffer sb = new StringBuffer();
        Object[] checkedElements = this.getViewer().getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            IFile element = (IFile)checkedElements[i];
            String name = element.getProjectRelativePath().toString();
            sb.append(name);
            sb.append("\n");
            result.add(element);
            ++i;
        }
        this.setResult(result);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }
}

