/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.core;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.privilege.core.Argument;
import org.tizen.web.privilege.core.Arguments;

public class Api {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String privilege;
    private String name;
    Arguments arguments = new Arguments();

    public Api(String name) {
        this.name = name;
    }

    public Api(String name, String privilege) {
        this.name = name;
        this.privilege = privilege;
    }

    public int getArgumentsSize() {
        return this.arguments.size();
    }

    public void addArgument(Argument argument) {
        if (this.arguments.put(argument.getName(), argument) != null) {
            this.logger.warn("failed to put api: " + argument.getName());
        }
    }

    public Argument getArgument(String argumentName) {
        Argument argument = this.arguments.getArgument(argumentName);
        return argument;
    }

    public String getName() {
        return this.name;
    }

    public String getPrivilege() {
        return this.privilege;
    }

    public void setPrivilege(String privilege) {
        this.privilege = privilege;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "[" + this.getPrivilege() + "]";
    }

    public String getArgumentPrivilege(String argumentText, int argumentIndex) {
        for (Map.Entry elem : this.arguments.entrySet()) {
            if (!((Argument)elem.getValue()).containsProperty(argumentText) || ((Argument)elem.getValue()).getIndex() != argumentIndex) continue;
            return ((Argument)elem.getValue()).getPrivilege();
        }
        return null;
    }
}

