/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.rest.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLPropertyDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMElementDeclarationImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractXMLModelQueryCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.IReferenceEnabled;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.Request;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.ui.dialogs.AbstractAddDialog;
import org.tizen.common.rest.ui.dialogs.RestParamLableProvider;
import org.tizen.common.rest.ui.views.RestViewerContentProvider;
import org.tizen.common.rest.ui.views.RestViewerLabelProvider;
import org.tizen.common.rest.util.ModelUtil;
import org.tizen.common.rest.util.StringUtil;
import org.tizen.web.rest.RestWebUIMessages;
import org.tizen.web.rest.template.ITemplateConstants;
import org.tizen.web.rest.ui.model.RestAPIModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RestFunctionSelectionDialog
extends AbstractAddDialog<FunctionSelectResult> {
    private static ILabelProvider contentProposalLabelProvider = new LabelProvider(){

        public Image getImage(Object element) {
            if (element instanceof ContentProposal) {
                return SharedXMLEditorPluginImageHelper.getImage((String)"icons/full/tobj16/attribute_obj.png");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ContentProposal) {
                ContentProposal proposal = (ContentProposal)element;
                return proposal.getLabel();
            }
            return super.getText(element);
        }
    };
    private static final ViewerFilter functionTableFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String methodName = (String)parentElement;
            RestAPIModel model = (RestAPIModel)element;
            return model.getMethod().equalsIgnoreCase(methodName);
        }
    };
    private static String[] paramTableHeader = new String[]{"Name", "Value", "Style"};
    private static int[] paramTableWeight = new int[]{40, 40, 20};
    private static String[] functionTableHeader = new String[]{"Method", "Name", "Signature"};
    private static int[] functionTableWeight = new int[]{10, 30, 60};
    private TreePath path;
    private List<RestAPIModel> apiList;
    private TreeViewer treeViewer;
    private TableViewer paramTableViewer;
    private TableViewer functionTableViewer;
    private Text textUrl;
    private Text textMethod;
    private Button checkEventNameEnabled;
    private Text textEventName;
    private Text textCallName;
    private Node node;
    private String defaultEventName;
    private String defaultCallName;
    private boolean eventNameEnabled;
    private static TextContentAdapter textContentAdapter;
    private static HtmlAttrProposalProvider contentProposalProvider;

    public RestFunctionSelectionDialog(Shell parent, TreePath path, List<RestAPIModel> apiList, Node node, String defaultEventName, String defaultCallName, boolean eventNameEnabled) {
        super(parent, 67696, RestWebUIMessages.RestFunctionSelectionDialog_title);
        this.path = path;
        this.apiList = apiList;
        this.node = node;
        this.defaultEventName = defaultEventName;
        this.defaultCallName = defaultCallName;
        this.eventNameEnabled = eventNameEnabled;
    }

    private List<CMNode> addModelQueryAttributeDeclarations(IDOMNode node, CMElementDeclaration elementDecl, String allowPrefix) {
        if (node.getNodeType() == 1) {
            List<CMNode> nodes = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument()).getAvailableContent((Element)node, elementDecl, 1);
            nodes = this.filterAvailableModelQueryCMNodes(nodes, allowPrefix);
            this.sortAttributes(nodes);
            return nodes;
        }
        return Collections.emptyList();
    }

    private void sortAttributes(List<CMNode> nodes) {
        Collections.sort(nodes, new Comparator<CMNode>(){

            @Override
            public int compare(CMNode o1, CMNode o2) {
                return o1.getNodeName().compareTo(o2.getNodeName());
            }
        });
    }

    private List<CMNode> filterAvailableModelQueryCMNodes(List<CMNode> modelQueryNodes, String allowPrefix) {
        ArrayList<CMNode> filtered = new ArrayList<CMNode>(modelQueryNodes.size());
        for (CMNode node : modelQueryNodes) {
            if (!this.validModelQueryNode(node) || !node.getNodeName().toLowerCase().startsWith(allowPrefix)) continue;
            filtered.add(node);
        }
        return filtered;
    }

    protected boolean validModelQueryNode(CMNode node) {
        boolean isValid = false;
        Object cmdoc = node.getProperty("CMDocument");
        if (cmdoc instanceof CMNode) {
            String name = ((CMNode)cmdoc).getNodeName();
            isValid = name != null && name.endsWith(".dtd") && name.indexOf("html") != -1;
        } else if (node.supports("isHTML")) {
            Boolean isHTML = (Boolean)node.getProperty("isHTML");
            isValid = isHTML == null || isHTML != false;
        } else if (node instanceof HTMLPropertyDeclaration) {
            HTMLPropertyDeclaration propDec = (HTMLPropertyDeclaration)node;
            isValid = !propDec.isJSP();
        } else if (node instanceof CMAttributeDeclaration || node instanceof CMElementDeclarationImpl) {
            isValid = true;
        } else if (node instanceof CMElementDeclaration) {
            Boolean isXHTML = (Boolean)node.getProperty("isXHTML");
            boolean bl = isValid = isXHTML != null && isXHTML != false;
        }
        if (isValid && node.supports("isObsolete")) {
            Boolean isObsolete = (Boolean)node.getProperty("isObsolete");
            isValid = isObsolete == null || isObsolete == false;
        }
        return isValid;
    }

    protected void createContents(Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        GridData data = new GridData(4, 4, true, true, 3, 1);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createTreeViewerArea(composite);
        this.createApiInfoArea(composite);
        this.createFunctionTableViewerArea(composite);
        this.createCallNameArea(composite);
        this.initializeContentProposal();
    }

    private void initializeContentProposal() {
        if (this.node != null) {
            CMElementDeclaration elementDecl;
            if (contentProposalProvider == null && (elementDecl = AbstractXMLModelQueryCompletionProposalComputer.getCMElementDeclaration((Node)this.node)) != null) {
                List<CMNode> list = this.addModelQueryAttributeDeclarations((IDOMNode)this.node, elementDecl, "on");
                textContentAdapter = new TextContentAdapter();
                contentProposalProvider = new HtmlAttrProposalProvider(list);
            }
            ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.textEventName, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)contentProposalProvider, null, null, true);
            adapter.setProposalAcceptanceStyle(2);
            adapter.setLabelProvider(contentProposalLabelProvider);
        }
    }

    protected void initData() {
        this.treeViewer.setSelection((ISelection)new TreeSelection(this.path), true);
        this.textCallName.setText(this.defaultCallName);
        if (this.defaultEventName != null && this.defaultEventName.length() > 0) {
            this.textEventName.setText(this.defaultEventName);
        }
    }

    private void createCallNameArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createSeparator(composite, 4);
        this.checkEventNameEnabled = new Button(parent, 32);
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.checkEventNameEnabled.setLayoutData((Object)gd);
        this.checkEventNameEnabled.setEnabled(this.eventNameEnabled);
        this.checkEventNameEnabled.setSelection(!this.eventNameEnabled);
        this.checkEventNameEnabled.setText(RestWebUIMessages.RestFunctionSelectionDialog_checkEventNameEnabled_label);
        this.checkEventNameEnabled.setToolTipText(RestWebUIMessages.RestFunctionSelectionDialog_checkEventNameEnabled_tooltip);
        this.checkEventNameEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = RestFunctionSelectionDialog.this.checkEventNameEnabled.getSelection();
                RestFunctionSelectionDialog.this.changeEventNameEnabledStatus(!selected);
            }
        });
        Label l = new Label(composite, 0);
        l.setText(RestWebUIMessages.RestFunctionSelectionDialog_eventName_label);
        Font oldFont = l.getFont();
        FontData fd = oldFont.getFontData()[0];
        fd.setStyle(1);
        final Font f = new Font(oldFont.getDevice(), fd);
        l.setFont(f);
        l.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (f != null && !f.isDisposed()) {
                    f.dispose();
                }
            }
        });
        this.textEventName = this.createText(composite, 2052, 0, 0, this.eventNameEnabled, 1);
        gd = new GridData();
        gd.widthHint = 120;
        this.textEventName.setLayoutData((Object)gd);
        this.textEventName.setEnabled(this.eventNameEnabled);
        l = new Label(composite, 0);
        l.setText(RestWebUIMessages.RestFunctionSelectionDialog_callName_label);
        l.setFont(f);
        l.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (f != null && !f.isDisposed()) {
                    f.dispose();
                }
            }
        });
        this.textCallName = this.createText(composite, 2052, 0, 0, true, 1);
        gd = new GridData(768);
        this.textCallName.setLayoutData((Object)gd);
        this.textCallName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 && RestFunctionSelectionDialog.this.validate()) {
                    RestFunctionSelectionDialog.this.okButtonPressed();
                }
            }
        });
    }

    protected void changeEventNameEnabledStatus(boolean eventNameEnabled) {
        this.eventNameEnabled = eventNameEnabled;
        this.textEventName.setEnabled(eventNameEnabled);
        if (eventNameEnabled) {
            if (!this.getMandatoryList().contains(this.textEventName)) {
                this.addToMandatoryList(this.textEventName);
            }
        } else {
            this.removeFromMandatoryList(this.textEventName);
        }
        this.updateOkButtonState();
    }

    private void createTreeViewerArea(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(RestWebUIMessages.RestFunctionSelectionDialog_tree_label);
        this.treeViewer = new TreeViewer(parent, 2820);
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 120;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new RestViewerContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new RestViewerLabelProvider(), decorator));
        this.treeViewer.setInput((Object)RepositoryManager.getInstance().getApplications());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RestFunctionSelectionDialog.this.treeSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void createApiInfoArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(RestWebUIMessages.RestFunctionSelectionDialog_apiInfo_group_label);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(4, false));
        Label labelUrl = new Label((Composite)group, 0);
        labelUrl.setText(RestWebUIMessages.RestFunctionSelectionDialog_url_label);
        this.textUrl = new Text((Composite)group, 2060);
        gd = new GridData(768);
        this.textUrl.setLayoutData((Object)gd);
        Label labelMethod = new Label((Composite)group, 0);
        labelMethod.setText(RestWebUIMessages.RestFunctionSelectionDialog_method_label);
        this.textMethod = new Text((Composite)group, 2060);
        gd = new GridData();
        gd.widthHint = 80;
        this.textMethod.setLayoutData((Object)gd);
        Label labelTable = new Label((Composite)group, 0);
        labelTable.setText(RestWebUIMessages.RestFunctionSelectionDialog_param_table_label);
        gd = new GridData();
        gd.horizontalSpan = 4;
        labelTable.setLayoutData((Object)gd);
        this.paramTableViewer = new TableViewer((Composite)group, 68356);
        this.paramTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = this.paramTableViewer.getTable();
        this.createParamTableColumn(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.heightHint = 80;
        gd.horizontalSpan = 4;
        table.setLayoutData((Object)gd);
    }

    protected void createParamTableColumn(Table table) {
        RestParamLableProvider colLabelProvider = new RestParamLableProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                int index = cell.getColumnIndex();
                String value = StringUtil.getConvertedStringFromActiveProfile((String)this.getColumnText(element, index));
                cell.setText(value);
            }

            public String getColumnText(Object element, int columnIndex) {
                Param param = (Param)element;
                switch (columnIndex) {
                    case 0: {
                        return param.getName();
                    }
                    case 1: {
                        return param.getDefault();
                    }
                    case 2: {
                        return param.getStyle().value();
                    }
                }
                return "";
            }
        };
        TableViewerColumn col = null;
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < paramTableHeader.length) {
            col = RestFunctionSelectionDialog.createTableViewerColumn(layout, this.paramTableViewer, paramTableHeader[i], paramTableWeight[i]);
            col.setLabelProvider((CellLabelProvider)colLabelProvider);
            ++i;
        }
        table.setLayout((Layout)layout);
    }

    public static TableViewerColumn createTableViewerColumn(TableLayout layout, TableViewer viewer, String title, int weight) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        ColumnWeightData data = new ColumnWeightData(weight, true);
        layout.addColumnData((ColumnLayoutData)data);
        column.setText(title);
        return viewerColumn;
    }

    private void createFunctionTableViewerArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(RestWebUIMessages.RestFunctionSelectionDialog_function_table_label);
        this.functionTableViewer = new TableViewer(parent, 68356);
        this.functionTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.functionTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RestFunctionSelectionDialog.this.updateOkButtonState();
            }
        });
        this.functionTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (RestFunctionSelectionDialog.this.validate()) {
                    RestFunctionSelectionDialog.this.okButtonPressed();
                }
            }
        });
        Table table = this.functionTableViewer.getTable();
        this.createFunctionTableColumn(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
    }

    private void createFunctionTableColumn(Table table) {
        RestFunctionLableProvider colLabelProvider = new RestFunctionLableProvider();
        TableViewerColumn col = null;
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < functionTableHeader.length) {
            col = RestFunctionSelectionDialog.createTableViewerColumn(layout, this.functionTableViewer, functionTableHeader[i], functionTableWeight[i]);
            col.setLabelProvider((CellLabelProvider)colLabelProvider);
            ++i;
        }
        table.setLayout((Layout)layout);
    }

    protected void treeSelectionChanged(IStructuredSelection selection) {
        IRestUiModel model = (IRestUiModel)selection.getFirstElement();
        this.updateApiInfo(model);
        this.updateFunctionTable(model);
    }

    private void updateApiInfo(IRestUiModel model) {
        if (!(model instanceof Method)) {
            this.clearApiInfo();
        } else {
            Method m = (Method)model;
            LinkedHashMap<String, Param> buf = new LinkedHashMap<String, Param>();
            this.initializeParentParams(buf, (IWadlModel)m);
            String url = StringUtil.getFullPathString((IRestUiModel)m);
            m = (Method)ModelUtil.findReferences((IReferenceEnabled)m);
            String methodName = m.getName();
            try {
                this.textUrl.setText(url);
                this.textMethod.setText(methodName);
                this.updateParamTable(buf, m);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    private void clearApiInfo() {
        this.textUrl.setText("");
        this.textMethod.setText("");
        this.paramTableViewer.setInput(null);
    }

    private void initializeParentParams(Map<String, Param> buf, IWadlModel model) {
        IWadlModel parent = model.getParent();
        if (parent instanceof Resource) {
            Resource res = (Resource)parent;
            List paramList = res.getParam();
            this.fillParameters(buf, paramList, false);
            this.initializeParentParams(buf, (IWadlModel)res);
        }
    }

    private void fillParameters(Map<String, Param> buf, List<Param> paramList, boolean overwrite) {
        int i = 0;
        while (i < paramList.size()) {
            Param param = paramList.get(i);
            param = (Param)ModelUtil.findReferences((IReferenceEnabled)param);
            String name = param.getName();
            if (overwrite || !buf.containsKey(name)) {
                buf.put(name, param);
            }
            ++i;
        }
    }

    private void updateParamTable(Map<String, Param> buf, Method model) {
        Request req = model.getRequest();
        if (req != null) {
            List repList = req.getRepresentation();
            int i = 0;
            while (i < repList.size()) {
                Representation rep = (Representation)repList.get(i);
                rep = (Representation)ModelUtil.findReferences((IReferenceEnabled)rep);
                String mediaType = rep.getMediaType();
                List paramList = rep.getParam();
                if (!"multipart/form-data".equals(mediaType)) {
                    this.fillParameters(buf, paramList, true);
                }
                ++i;
            }
            List paramList = req.getParam();
            this.fillParameters(buf, paramList, true);
        }
        this.paramTableViewer.setInput(buf.values());
    }

    private void updateFunctionTable(IRestUiModel model) {
        if (!(model instanceof Method)) {
            this.functionTableViewer.setInput(null);
        } else {
            Method m = (Method)model;
            m = (Method)ModelUtil.findReferences((IReferenceEnabled)m);
            String methodName = m.getName();
            Object[] filtered = functionTableFilter.filter((Viewer)this.functionTableViewer, (Object)methodName, this.apiList.toArray());
            this.functionTableViewer.setInput((Object)filtered);
            if (filtered.length > 0) {
                this.functionTableViewer.getTable().select(0);
            }
        }
    }

    protected FunctionSelectResult makeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.functionTableViewer.getSelection();
        RestAPIModel model = (RestAPIModel)selection.getFirstElement();
        String eventName = this.textEventName.getText();
        String callName = this.textCallName.getText();
        return new FunctionSelectResult(model, eventName, callName, this.eventNameEnabled);
    }

    protected Control getFirstFocusControl() {
        return this.functionTableViewer.getControl();
    }

    protected boolean validate() {
        boolean enabled = super.validate();
        return enabled &= !this.functionTableViewer.getSelection().isEmpty();
    }

    public class FunctionSelectResult {
        private RestAPIModel selectedModel;
        private String eventName;
        private String callName;
        private String templateKeyName;
        private boolean eventNameEnabled;

        public FunctionSelectResult(RestAPIModel selectedModel, String eventName, String callName, boolean eventNameEnabled) {
            this.selectedModel = selectedModel;
            this.eventName = eventName;
            this.callName = callName;
            this.eventNameEnabled = eventNameEnabled;
            this.templateKeyName = this.getTemplateKeyName(this.selectedModel);
        }

        private String getTemplateKeyName(RestAPIModel selectedModel) {
            String methodStr = selectedModel.getMethod();
            boolean isFilePost = selectedModel.isFilePost();
            String[] stringArray = ITemplateConstants.TEMPLATE_KEYS_FUNCTION;
            int n = ITemplateConstants.TEMPLATE_KEYS_FUNCTION.length;
            int n2 = 0;
            while (n2 < n) {
                String templateName = stringArray[n2];
                if (templateName.endsWith(methodStr)) {
                    if ("POST".equals(methodStr) && isFilePost) {
                        return "TEMPLATE_KEY_FUNCTION_POST_FILE";
                    }
                    return templateName;
                }
                ++n2;
            }
            return "TEMPLATE_KEY_FUNCTION_GET";
        }

        public RestAPIModel getSelectedModel() {
            return this.selectedModel;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getCallName() {
            return this.callName;
        }

        public String getTemplateKeyName() {
            return this.templateKeyName;
        }

        public boolean isEventNameEnabled() {
            return this.eventNameEnabled;
        }
    }

    public class HtmlAttrProposalProvider
    implements IContentProposalProvider {
        private List<CMNode> attributes;

        public HtmlAttrProposalProvider(List<CMNode> list) {
            this.attributes = list;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<ContentProposal> buf = new ArrayList<ContentProposal>();
            int i = 0;
            while (i < this.attributes.size()) {
                CMNode node = this.attributes.get(i);
                String name = node.getNodeName();
                String prefix = contents.substring(0, position);
                if (name.toLowerCase().startsWith(prefix.toLowerCase())) {
                    char[] chars = name.toCharArray();
                    if (chars.length > 2) {
                        chars[2] = (char)(chars[2] - 32);
                        name = new String(chars);
                    }
                    buf.add(new ContentProposal(name, name, "Event attribute : " + name, position));
                }
                ++i;
            }
            return buf.toArray(new IContentProposal[buf.size()]);
        }
    }

    public class RestFunctionLableProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            int index = cell.getColumnIndex();
            RestAPIModel model = (RestAPIModel)element;
            String value = null;
            switch (index) {
                case 0: {
                    value = model.getMethod();
                    break;
                }
                case 1: {
                    value = model.getElementName();
                    break;
                }
                case 2: {
                    value = model.getSignature();
                    break;
                }
                default: {
                    value = "";
                }
            }
            cell.setText(value);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            RestAPIModel model = (RestAPIModel)element;
            switch (columnIndex) {
                case 0: {
                    return model.getMethod();
                }
                case 1: {
                    return model.getElementName();
                }
                case 2: {
                    return model.getSignature();
                }
            }
            return "";
        }
    }
}

