/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.action;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ImageUtil;
import org.tizen.web.unittest.WebUnitTestPlugin;
import org.tizen.web.unittest.nls.NLSString;
import org.tizen.web.unittest.resultview.action.IActionRunNotifyRequester;
import org.tizen.web.unittest.resultview.model.WUTResultTestCase;

public class RunCheckedAction
extends Action
implements IActionRunNotifyRequester {
    private static final Logger logger = LoggerFactory.getLogger(RunCheckedAction.class);
    private CheckboxTreeViewer testResultTreeViewer;
    private ILaunchConfiguration config = null;
    private String mode = null;

    public RunCheckedAction(CheckboxTreeViewer testResultTreeViewer) {
        this.testResultTreeViewer = testResultTreeViewer;
        this.setImageDescriptor(ImageUtil.getImageDescriptor((Plugin)WebUnitTestPlugin.getDefault(), (String)"icons/elcl18/run_checked.png"));
        this.setDisabledImageDescriptor(ImageUtil.getImageDescriptor((Plugin)WebUnitTestPlugin.getDefault(), (String)"icons/dlcl18/run_checked.png"));
        this.setToolTipText(NLSString.ACTION_TOOLTIP_RUN_CHECKED);
    }

    public void setLaunchInfo(ILaunchConfiguration config, String mode) {
        this.config = config;
        this.mode = mode;
    }

    public void run() {
        if (this.config != null && this.mode != null) {
            try {
                ArrayList<WUTResultTestCase> testCaseList = new ArrayList<WUTResultTestCase>();
                Object[] objectArray = this.testResultTreeViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof WUTResultTestCase) {
                        testCaseList.add((WUTResultTestCase)element);
                    }
                    ++n2;
                }
                StringBuffer sb = new StringBuffer();
                for (WUTResultTestCase testCase : testCaseList) {
                    sb.append(",").append(testCase.getParent().getName()).append(": ").append(testCase.getName());
                }
                String filterOption = sb.toString().replaceFirst(",", "");
                ILaunchConfigurationWorkingCopy wc = this.config.getWorkingCopy();
                wc.setAttribute("attribute_wut_query", filterOption);
                wc.doSave();
                DebugUITools.launch((ILaunchConfiguration)this.config, (String)"run");
            }
            catch (CoreException e) {
                logger.error(NLSString.MSG_FAIL_TO_SET_FILTER_OPTION, (Throwable)e);
            }
        }
    }

    @Override
    public void notifyActionRun() {
        if (this.testResultTreeViewer.getCheckedElements().length == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

