/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.debug.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tizen.web.common.ChromeLauncher;
import org.tizen.web.preferences.ChromePreferenceInitializer;

public class Inspector {
    private String name;
    private Process process;
    private String url;
    private List<String> options = new ArrayList<String>();
    public static final String[] DEFAULT_INSPECTOR_OPTIONS = ChromePreferenceInitializer.DEFAULT_CHROME_OPTIONS;

    public Inspector(String name, String url) {
        this.name = name;
        this.process = null;
        this.url = url;
        this.setOptions(DEFAULT_INSPECTOR_OPTIONS);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRunning() {
        return this.process != null;
    }

    public boolean refresh() throws IOException {
        if (this.isRunning()) {
            this.kill();
        }
        return this.run();
    }

    public boolean run() throws IOException {
        ChromeLauncher launcher = new ChromeLauncher();
        launcher.setOptions(this.getOptions());
        this.process = launcher.launch(this.getUrl(), ChromeLauncher.TYPE.APP);
        return this.process != null;
    }

    public String[] getOptions() {
        return this.options.toArray(new String[this.options.size()]);
    }

    public void setOptions(String ... options) {
        this.options.clear();
        this.options.addAll(Arrays.asList(options));
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    private String getUrl() {
        return this.url;
    }

    public boolean kill() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        return true;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

