/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.web.localization.LocaleItem;
import org.tizen.web.localization.LocalizationPlugin;

public class AssociationsTableLabelProvider
implements ITableLabelProvider {
    public static final String CHECKED_IMAGE = "checked";
    public static final String UNCHECKED_IMAGE = "unchecked";
    public static final String CHECKED_GRAYED_IMAGE = "checked-grayed";
    private static ImageRegistry imageRegistry = new ImageRegistry();
    List<Locale> fSelectedLocales = null;

    static {
        String iconPath = "icons/";
        imageRegistry.put(CHECKED_IMAGE, LocalizationPlugin.getImageDescriptor(String.valueOf(iconPath) + CHECKED_IMAGE + ".gif"));
        imageRegistry.put(UNCHECKED_IMAGE, LocalizationPlugin.getImageDescriptor(String.valueOf(iconPath) + UNCHECKED_IMAGE + ".gif"));
        imageRegistry.put(CHECKED_GRAYED_IMAGE, LocalizationPlugin.getImageDescriptor(String.valueOf(iconPath) + CHECKED_GRAYED_IMAGE + ".gif"));
    }

    public AssociationsTableLabelProvider(List<Locale> selectedLocales) {
        this.fSelectedLocales = selectedLocales;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Map.Entry entry = (Map.Entry)element;
        Image image = null;
        if (columnIndex != 0) {
            int index = columnIndex - 1;
            Locale locale = this.fSelectedLocales.get(index);
            List localeItems = (List)entry.getValue();
            boolean isSelected = false;
            boolean isPreSelected = false;
            if (!((List)entry.getValue()).isEmpty()) {
                for (LocaleItem nextitem : localeItems) {
                    if (!nextitem.getLocale().equals(locale)) continue;
                    if (nextitem.isPreSelected()) {
                        isPreSelected = true;
                    }
                    isSelected = true;
                }
            }
            String key = UNCHECKED_IMAGE;
            key = isPreSelected ? CHECKED_GRAYED_IMAGE : (isSelected ? CHECKED_IMAGE : UNCHECKED_IMAGE);
            image = imageRegistry.get(key);
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        Map.Entry entry = (Map.Entry)element;
        if (columnIndex == 0) {
            result = ((IFile)entry.getKey()).getProjectRelativePath().toString();
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image get(ImageDescriptor desc) {
        return desc.createImage();
    }
}

