/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.properties.multi.control;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.packager.ui.properties.multi.model.ReferenceModel;

public class ReferenceController {
    Collection<ReferenceModel> rms = new LinkedHashSet<ReferenceModel>();
    private TizenProjectType selectedTizenProjectType;

    public ReferenceController(IProject project) {
        this.selectedTizenProjectType = org.tizen.common.util.ProjectUtil.getTizenProjectType((IProject)project);
        this.initReferenceModels(project);
    }

    private void initReferenceModels(IProject project) {
        this.rms.clear();
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        TizenProjectDescription selectedTpd = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)project);
        IProject[] iProjectArray = workspaceProjects;
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject workspaceProject = iProjectArray[n2];
            if (workspaceProject.isOpen() && !project.equals((Object)workspaceProject) && this.canReference(project, workspaceProject)) {
                String workspaceProjectName = workspaceProject.getName();
                TizenProjectType workspaceTpt = org.tizen.common.util.ProjectUtil.getTizenProjectType((IProject)workspaceProject);
                if (this.isReferencedWebWidget(selectedTpd, workspaceTpt)) {
                    ReferenceModel rm = new ReferenceModel(workspaceProjectName, workspaceTpt, this.isReferenced(selectedTpd, workspaceProjectName));
                    if (workspaceTpt.isNativeProject() && this.selectedTizenProjectType.getSelectableReferenceNum(workspaceTpt).equals((Object)TizenProjectType.SelectableReferenceNum.NATURAL) && this.getNativeRoot(this.rms) == null && this.isReferencedNativeRoot(selectedTpd, workspaceProjectName)) {
                        rm.setNativeRoot(true);
                    }
                    this.rms.add(rm);
                }
            }
            ++n2;
        }
    }

    private boolean isReferencedWebWidget(TizenProjectDescription selectedTpd, TizenProjectType workspaceTpt) {
        return !workspaceTpt.isWebWidgetApplicationProject() || ProjectUtil.isInstallWebWidgetFeature((ProfileInfo)selectedTpd.getProfileInfo(), (String)selectedTpd.getVersion());
    }

    private boolean isReferencedNativeRoot(TizenProjectDescription selectedTpd, String referenceProjectName) {
        List referenceProjects = selectedTpd.getSubProjectList();
        if (this.isReferenced(selectedTpd, referenceProjectName)) {
            for (TizenProjectDescription.RefTizenProject referenceProject : referenceProjects) {
                if (!referenceProject.getName().equals(referenceProjectName) || !"native main".equals(referenceProject.getStyle())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canReference(IProject selectedProject, IProject referencingProject) {
        TizenProjectType projectType = org.tizen.common.util.ProjectUtil.getTizenProjectType((IProject)referencingProject);
        if (projectType == null) {
            return false;
        }
        return projectType.isReferencedProject(org.tizen.common.util.ProjectUtil.getTizenProjectType((IProject)selectedProject));
    }

    private boolean isReferenced(TizenProjectDescription selectedTpd, String referenceProjectName) {
        List referenceProjects = selectedTpd.getSubProjectList();
        if (referenceProjects != null) {
            for (TizenProjectDescription.RefTizenProject rtp : referenceProjects) {
                if (!rtp.getName().equals(referenceProjectName)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<ReferenceModel> getReferenceModels(TizenProjectType tpt) {
        LinkedHashSet<ReferenceModel> rms = new LinkedHashSet<ReferenceModel>();
        for (ReferenceModel rm : this.getReferenceModels()) {
            if (!rm.getTizenProjectType().equals((Object)tpt)) continue;
            rms.add(rm);
        }
        return rms;
    }

    public Collection<ReferenceModel> getReferenceModels() {
        return this.rms;
    }

    public void setReferenced(ReferenceModel newRm, Boolean isReferenced) {
        Collection<ReferenceModel> rms = this.getReferenceModels(newRm.getTizenProjectType());
        TizenProjectType tpt = newRm.getTizenProjectType();
        if (this.selectedTizenProjectType.getSelectableReferenceNum(tpt).equals((Object)TizenProjectType.SelectableReferenceNum.ONE) && isReferenced.booleanValue()) {
            for (ReferenceModel oldRm : rms) {
                if (!oldRm.isReferenced()) continue;
                oldRm.setReferenced(false);
                break;
            }
        } else if (tpt.isNativeProject() && this.selectedTizenProjectType.getSelectableReferenceNum(tpt).equals((Object)TizenProjectType.SelectableReferenceNum.NATURAL)) {
            if (isReferenced.booleanValue()) {
                ReferenceModel oldRm = this.getNativeRoot(rms);
                if (oldRm == null) {
                    newRm.setNativeRoot(isReferenced);
                }
            } else {
                newRm.setNativeRoot(isReferenced);
                newRm.setReferenced(isReferenced);
                ReferenceModel oldRm = this.getNativeRoot(rms);
                if (oldRm == null) {
                    for (ReferenceModel rm : rms) {
                        if (!rm.isReferenced()) continue;
                        rm.setNativeRoot(isReferenced == false);
                        break;
                    }
                }
            }
        }
        newRm.setReferenced(isReferenced);
    }

    private ReferenceModel getNativeRoot(Collection<ReferenceModel> handleRms) {
        for (ReferenceModel handleRm : handleRms) {
            if (!handleRm.isNativeRoot()) continue;
            return handleRm;
        }
        return null;
    }

    public void setNativeRoot(ReferenceModel rm, Boolean isNativeRoot) {
        if (!rm.isReferenced()) {
            return;
        }
        Collection<ReferenceModel> handleRms = this.getReferenceModels(rm.getTizenProjectType());
        Iterator<ReferenceModel> iter = handleRms.iterator();
        if (isNativeRoot.booleanValue()) {
            while (iter.hasNext()) {
                ReferenceModel handleRm = iter.next();
                if (!handleRm.isNativeRoot()) continue;
                handleRm.setNativeRoot(isNativeRoot == false);
                break;
            }
        } else if (rm.isNativeRoot() && !isNativeRoot.booleanValue()) {
            return;
        }
        rm.setNativeRoot(isNativeRoot);
    }
}

