/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.KillStep;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;
import org.tizen.web.zimlaunch.util.LaunchUtil;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleFactory;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public abstract class LaunchStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(LaunchStep.class);
    public static final String name = Messages.RUN_PACKAGE;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected IDevice device;
    protected boolean isInstalled;
    protected int percent;

    public LaunchStep(IStep ... steps) {
        super(steps);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        this.executeStep(ctx, false);
    }

    public void executeStep(ILaunchContext ctx, boolean isWebWidget) throws Exception {
        UserLogger.start((String)"web.launch", (String)".run");
        this.preExecuteStep(ctx);
        String failMessage = Messages.getFailMessage((String)Messages.RUN_PACKAGE);
        String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
        String cmd = this.getLaunchCommand();
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device));
        if (version.isSameOrBiggerThanVersion3()) {
            cmd = cmd.replaceFirst("wrt-", "app_");
            if (LaunchUtil.isWatch(this.resource.getAppinfo().getProject())) {
                cmd = cmd.replaceFirst("--start", "--start org.tizen.widget_viewer_sdk widget_id");
            }
        }
        if (!this.isInstalled) {
            TizenWebIDEExceptionCode code = TizenWebIDEExceptionCode.WEB_IDE_WIDGET_NOT_INSTALLED;
            logger.error(this.makeErrorDescription(code));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(String.format("%s\n%s %s", errMsg, code.getDescription(), org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG)), new TizenWebNotifier[0]);
            return;
        }
        this.closeJsLogConsole(this.device);
        Calendar calendar = this.getCurrentDeviceCalendar(this.device);
        logger.debug("Command for running: " + cmd);
        this.launcher.runCommand(cmd, false);
        this.postRun();
        boolean isLaunched = this.launcher.isLaunched(isWebWidget);
        if (!isLaunched) {
            TizenWebIDEExceptionCode code = TizenWebIDEExceptionCode.WEB_IDE_STEPRUN_FAIL;
            logger.error(this.makeErrorDescription(code));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(String.format("%s\n%s %s", errMsg, code.getDescription(), org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG)), new TizenWebNotifier[0]);
        }
        this.openJsLogConsole(calendar);
        try {
            try {
                super.executeStep(ctx);
            }
            catch (Exception e) {
                this.handleExecuteException(e, ctx);
                UserLogger.end((String)"web.launch", (String)".run");
            }
        }
        finally {
            UserLogger.end((String)"web.launch", (String)".run");
        }
    }

    protected void handleExecuteException(Exception e, ILaunchContext ctx) throws Exception {
        if (e != null) {
            new KillStep().executeStep(ctx);
            throw e;
        }
    }

    protected Calendar getCurrentDeviceCalendar(IDevice device) throws Exception {
        if (device == null) {
            return null;
        }
        this.launcher.runCommand("date +\"%Y-%m-%d %H:%M:%S\"", false);
        SimpleDateFormat ft = new SimpleDateFormat("y-MM-dd hh:mm:ss");
        String result = this.launcher.getResultString();
        Date date = ft.parse(result);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    private void closeJsLogConsole(IDevice device) {
        if (device == null) {
            return;
        }
        JsLogConsoleFactory.closeJsLogConsole(device);
    }

    protected void openJsLogConsole(Calendar calendar) throws IOException {
        TizenWebAppInfo appInfo = this.resource.getAppinfo();
        IProject project = appInfo.getProject();
        String packageID = appInfo.getAppPackageID();
        String profile = appInfo.getProfile();
        Version version = new Version(appInfo.getVersion());
        JsLogReceiver receiver = new JsLogReceiver();
        receiver.setCalendar(calendar);
        receiver.setTargetVersion(new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device)));
        JsLogConsoleFactory.openJsLogConsole(project, this.device, packageID, receiver, profile, version);
    }

    protected void postRun() {
        String[] resultLineStrings = this.launcher.getResultLineStrings();
        if (resultLineStrings != null) {
            String[] stringArray = resultLineStrings;
            int n = resultLineStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String result = stringArray[n2];
                logger.debug("  " + result);
                ++n2;
            }
        }
    }

    protected String getLaunchCommand() throws Exception {
        return this.launcher.getCommand("RUN_LAUNCH_COMMAND", this.resource);
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String failMessage = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        String msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), new TizenWebNotifier[0]);
        }
        this.device = this.resource.getDeviceinfo().getDevice();
        JsLogConsoleFactory.clear(this.device);
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        if (this.launcher == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : this.notifier.getRemainWork() - 1;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

