/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.common.core.WebProjectUtil;

public class TizenWebProjectUtil
extends WebProjectUtil {
    protected static final Logger logger = LoggerFactory.getLogger(TizenWebProjectUtil.class);

    public static String getInstallUri(IProject project) {
        String result = TizenWebProjectUtil.getLocalWidgetLocation(project);
        if (result != null) {
            return "file://" + result;
        }
        return null;
    }

    public static IResource getWidgetResource(IProject project) {
        IFolder packages;
        if (project == null) {
            return null;
        }
        IResource widget = project.findMember(String.valueOf(project.getName()) + ".wgt");
        if (widget == null && (packages = project.getFolder("Packages")) != null) {
            widget = packages.getFile(String.valueOf(project.getName()) + ".wgt");
        }
        return widget;
    }

    public static String getLocalWidgetLocation(IProject project) {
        try {
            IResource widget = TizenWebProjectUtil.getWidgetResource(project);
            if (widget != null) {
                return widget.getLocation().toString();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }
}

