/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.Surrogate;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.ConnectionPluginSurrogate;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.web.zimlaunch.ActivatorSurrogate;
import org.tizen.web.zimlaunch.ConsolePluginSurrogate;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.preference.LaunchPreferencePage;
import org.tizen.web.zimlaunch.util.ConnectionUtil;
import org.tizen.web.zimlaunch.util.DeviceChangeListener;
import org.tizen.web.zimlaunch.util.WRTCommandUtil;

public class Activator
extends AbstractUIPlugin {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PLUGIN_ID = "org.tizen.web.zimlaunch";
    public static final String LAUNCH_CONFIGURATION_TYPE = "org.tizen.web.zimlaunch.WebAppLaunch";
    private static Activator plugin;
    private static BundleContext fgBundleContext;
    private static DeviceChangeListener listener;

    static {
        listener = new DeviceChangeListener();
    }

    public void start(BundleContext context) throws Exception {
        fgBundleContext = context;
        super.start(context);
        plugin = this;
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)listener);
        TizenWebConsole.setSurrogate(new ConsolePluginSurrogate());
        WRTCommandUtil.getInstance().setSurrogate(new ActivatorSurrogate());
        ConnectionUtil.getInstance().setSurrogate((Surrogate<ConnectionPlugin>)new ConnectionPluginSurrogate());
        ConnectionUtil.getInstance().setSelectedDevice(ConnectionPlugin.getDefault().getCurrentDevice());
        ConnectionPlugin.getDefault().addSelectionListener((ConnectionPlugin.ISelectionListener)ConnectionUtil.getInstance());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        fgBundleContext = null;
        SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)listener);
        ConnectionPlugin.getDefault().removeSelectionListener((ConnectionPlugin.ISelectionListener)ConnectionUtil.getInstance());
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    public void initializeDefaultPreferences(IPreferenceStore store) {
        this.setInitialPreferences(store);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    private void setInitialPreferences(IPreferenceStore store) {
        block15: {
            InputStream is = null;
            try {
                try {
                    String defaultValue;
                    is = LaunchPreferencePage.class.getClassLoader().getResourceAsStream("resource/LaunchCommand.properties");
                    Properties props = new Properties();
                    props.load(is);
                    if (!store.getDefaultBoolean("OPTION_ENABLE")) {
                        store.setDefault("OPTION_ENABLE", true);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("QUERY_COMMAND"))) {
                        defaultValue = props.getProperty("QUERY_COMMAND");
                        store.setDefault("QUERY_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("INSTALL_COMMAND"))) {
                        defaultValue = props.getProperty("INSTALL_COMMAND");
                        store.setDefault("INSTALL_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("UNINSTALL_COMMAND"))) {
                        defaultValue = props.getProperty("UNINSTALL_COMMAND");
                        store.setDefault("UNINSTALL_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("RUN_LAUNCH_COMMAND"))) {
                        defaultValue = props.getProperty("RUN_LAUNCH_COMMAND");
                        store.setDefault("RUN_LAUNCH_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("WIDGET_LAUNCH_COMMAND"))) {
                        defaultValue = props.getProperty("WIDGET_LAUNCH_COMMAND");
                        store.setDefault("WIDGET_LAUNCH_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("DEBUG_LAUNCH_COMMAND"))) {
                        defaultValue = props.getProperty("DEBUG_LAUNCH_COMMAND");
                        store.setDefault("DEBUG_LAUNCH_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("KILL_COMMAND"))) {
                        defaultValue = props.getProperty("KILL_COMMAND");
                        store.setDefault("KILL_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("WIDGET_KILL_COMMAND"))) {
                        defaultValue = props.getProperty("WIDGET_KILL_COMMAND");
                        store.setDefault("WIDGET_KILL_COMMAND", defaultValue);
                    }
                    if (StringUtil.isEmpty((CharSequence)store.getString("RUN_CHECK_COMMAND"))) {
                        defaultValue = props.getProperty("RUN_CHECK_COMMAND");
                        store.setDefault("RUN_CHECK_COMMAND", defaultValue);
                    }
                }
                catch (IOException e) {
                    this.logger.error("Failed to set defaults", (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{is});
                    break block15;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
    }
}

