/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.DocumentStyleImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FilenameUtil;
import org.tizen.web.editor.Activator;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.html.refactoring.WebFileRefactoringConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

public class WebFileMoveChange
extends ResourceChange
implements WebFileRefactoringConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IResource fSource;
    private final IContainer fTarget;
    private final String fileName;
    private Map<String, IResource> htmlFiles;
    private ChangeDescriptor fDescriptor;

    public WebFileMoveChange(IResource source, IContainer target) {
        this.fSource = source;
        this.fileName = this.fSource.getName();
        this.fTarget = target;
        IProject project = this.fSource.getProject();
        WebResourceManager resourceManager = new WebResourceManager(project);
        resourceManager.makeProjectManagedResourceMap();
        this.htmlFiles = resourceManager.getHtmlFiles();
        this.setValidationMethod(2);
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public Change perform(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.refactoring(monitor);
        IFile movedFile = this.getMovedFile(this.fSource, this.fTarget);
        return new WebFileMoveChange((IResource)movedFile, this.fSource.getParent());
    }

    protected IResource getModifiedResource() {
        return this.fSource;
    }

    public String getName() {
        return Messages.format((String)RefactoringCoreMessages.MoveResourceChange_name, (Object[])new String[]{BasicElementLabels.getPathLabel((IPath)this.fSource.getFullPath(), (boolean)false), BasicElementLabels.getResourceName((IResource)this.fTarget)});
    }

    private void refactoring(IProgressMonitor monitor) {
        String extension = this.fSource.getFileExtension();
        WebFileRefactoringConstants.FileExtension fileExtension = WebFileRefactoringConstants.FileExtension.getFileExtension(extension);
        if (fileExtension == null) {
            fileExtension = WebFileRefactoringConstants.FileExtension.IMAGE;
        }
        if (fileExtension == WebFileRefactoringConstants.FileExtension.HTML || fileExtension == WebFileRefactoringConstants.FileExtension.HTM) {
            IProject project = this.fSource.getProject();
            WebResourceManager resourceManager = new WebResourceManager(project);
            resourceManager.makeProjectManagedResourceMap();
            this.htmlFiles = resourceManager.getHtmlFiles();
        }
        WebResourceManager.checkLocaleResources((IResource)this.fSource, this.htmlFiles.entrySet().iterator());
        for (Map.Entry<String, IResource> fileEntry : this.htmlFiles.entrySet()) {
            IFile file = (IFile)fileEntry.getValue();
            try {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                IStructuredModel model = modelManager.getModelForEdit(file);
                if (model == null) continue;
                DOMStyleModelImpl dom = (DOMStyleModelImpl)model;
                IDOMDocument document = dom.getDocument();
                this.refactoring(file, fileExtension, document);
                IStructuredDocument structuredDocument = model.getStructuredDocument();
                modelManager.saveStructuredDocument(structuredDocument, file);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void refactoring(IFile file, WebFileRefactoringConstants.FileExtension fileExtension, IDOMDocument document) {
        String tagName = null;
        String attributeName = null;
        switch (fileExtension) {
            case HTML: 
            case HTM: {
                tagName = "a";
                attributeName = "href";
                this.processRefactoring(file, document, tagName, attributeName);
                tagName = "iframe";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                IFile movedFile = this.getMovedFile(this.fSource, this.fTarget);
                this.processRefactoringForMovingHtml(movedFile, document);
                break;
            }
            case CSS: {
                tagName = "link";
                attributeName = "href";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case JS: {
                tagName = "script";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case IMAGE: {
                tagName = "img";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
        }
    }

    private IFile getMovedFile(IResource origin, IContainer container) {
        String fileName = origin.getName();
        IPath movedPath = container.getFullPath().append(fileName);
        IPath removeFirstSegments = movedPath.removeFirstSegments(1);
        IProject project = origin.getProject();
        IFile file = project.getFile(removeFirstSegments);
        return file;
    }

    private void processRefactoringForMovingHtml(IFile file, IDOMDocument document) {
        Map imageFiles;
        Map cssFiles;
        Map jsFiles;
        IProject project = file.getProject();
        WebResourceManager resourceManager = new WebResourceManager(project, file);
        resourceManager.makeProjectManagedResourceMap();
        String tagName = null;
        String attributeName = null;
        Map htmlFiles = resourceManager.getHtmlFiles();
        if (htmlFiles != null && htmlFiles.size() > 0) {
            Set htmlEntrySet = htmlFiles.entrySet();
            for (Map.Entry html : htmlEntrySet) {
                String relativePath = (String)html.getKey();
                IFile linkedHtmlFile = (IFile)html.getValue();
                String linkedHtmlFileName = linkedHtmlFile.getName();
                tagName = "a";
                attributeName = "href";
                this.processRefactoringForMovingHtml(file, document, linkedHtmlFileName, relativePath, tagName, attributeName);
                tagName = "iframe";
                attributeName = "src";
                this.processRefactoringForMovingHtml(file, document, linkedHtmlFileName, relativePath, tagName, attributeName);
            }
        }
        if ((jsFiles = resourceManager.getJsFiles()) != null && jsFiles.size() > 0) {
            Set jsEntrySet = jsFiles.entrySet();
            for (Map.Entry js : jsEntrySet) {
                String relativePath = (String)js.getKey();
                IFile linkedJsFile = (IFile)js.getValue();
                String linkedJsFileName = linkedJsFile.getName();
                tagName = "script";
                attributeName = "src";
                this.processRefactoringForMovingHtml(file, document, linkedJsFileName, relativePath, tagName, attributeName);
            }
        }
        if ((cssFiles = resourceManager.getCssFiles()) != null && cssFiles.size() > 0) {
            Set cssEntrySet = cssFiles.entrySet();
            for (Map.Entry css : cssEntrySet) {
                String relativePath = (String)css.getKey();
                IFile linkedCssFile = (IFile)css.getValue();
                String linkedCssFileName = linkedCssFile.getName();
                tagName = "link";
                attributeName = "href";
                this.processRefactoringForMovingHtml(file, document, linkedCssFileName, relativePath, tagName, attributeName);
            }
        }
        if ((imageFiles = resourceManager.getImageFiles()) != null && imageFiles.size() > 0) {
            Set imageEntrySet = imageFiles.entrySet();
            for (Map.Entry image : imageEntrySet) {
                String relativePath = (String)image.getKey();
                IFile linkedImageFile = (IFile)image.getValue();
                String linkedImageFileName = linkedImageFile.getName();
                tagName = "img";
                attributeName = "src";
                this.processRefactoringForMovingHtml(file, document, linkedImageFileName, relativePath, tagName, attributeName);
            }
        }
    }

    private void processRefactoringForMovingHtml(IFile htmlFile, IDOMDocument document, String linkedFileName, String linkedFileRelativePath, String tagName, String attributeName) {
        NodeList nodeList = ((DocumentStyleImpl)document).getElementsByTagName(tagName);
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String attribute;
                ElementStyleImpl element = (ElementStyleImpl)nodeList.item(i);
                Attr attributeNode = element.getAttributeNode(attributeName);
                if (attributeNode != null && (attribute = element.getAttribute(attributeName)).contains(linkedFileName)) {
                    attributeNode.setNodeValue(linkedFileRelativePath);
                    IStructuredDocumentRegion startStructuredDocumentRegion = element.getStartStructuredDocumentRegion();
                    int start = startStructuredDocumentRegion.getStart();
                    IStructuredDocument parentDocument = startStructuredDocumentRegion.getParentDocument();
                    int lineOfOffset = parentDocument.getLineOfOffset(start) + 1;
                    this.print(htmlFile, "[MOVE REFACTOR] " + htmlFile.getName() + "(" + lineOfOffset + ")" + " is changed at '" + startStructuredDocumentRegion.getFullText() + "'.");
                }
                ++i;
            }
        }
    }

    private void processRefactoring(IFile file, IDOMDocument document, String tagName, String attributeName) {
        NodeList nodeList = ((DocumentStyleImpl)document).getElementsByTagName(tagName);
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String attribute;
                ElementStyleImpl element = (ElementStyleImpl)nodeList.item(i);
                Attr attributeNode = element.getAttributeNode(attributeName);
                if (attributeNode != null && (attribute = element.getAttribute(attributeName)).contains(this.fileName)) {
                    IPath targetPath = this.fTarget.getFullPath().append(this.fileName);
                    attribute = this.getRelativePath(file, targetPath);
                    attributeNode.setNodeValue(attribute);
                    IStructuredDocumentRegion startStructuredDocumentRegion = element.getStartStructuredDocumentRegion();
                    int start = startStructuredDocumentRegion.getStart();
                    IStructuredDocument parentDocument = startStructuredDocumentRegion.getParentDocument();
                    int lineOfOffset = parentDocument.getLineOfOffset(start) + 1;
                    this.print(file, "[MOVE REFACTOR] " + file.getName() + "(" + lineOfOffset + ")" + " is changed at '" + startStructuredDocumentRegion.getFullText() + "'.");
                }
                ++i;
            }
        }
    }

    private String getRelativePath(IFile source, IPath target) {
        String projectName = source.getProject().getName();
        String sourceFilePath = source.getFullPath().toString();
        sourceFilePath = sourceFilePath.substring(projectName.length() + 2);
        String targetFilePath = target.toString();
        targetFilePath = targetFilePath.substring(projectName.length() + 2);
        if ((targetFilePath = FilenameUtil.getRelativePath((String)sourceFilePath, (String)targetFilePath)).startsWith("../")) {
            targetFilePath = targetFilePath.substring(3);
        }
        return targetFilePath;
    }

    private void print(IFile file, String message) {
        try {
            MessageConsole refactorConsole = Activator.getDefault().getRefactorConsole();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{refactorConsole});
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)refactorConsole);
            MessageConsoleStream stream = refactorConsole.newMessageStream();
            stream.setActivateOnWrite(true);
            stream.println(message);
            stream.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

