/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.aural;

import java.io.IOException;
import java.net.URL;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.aural.ACssProperty;
import org.w3c.css.properties.aural.ACssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssURL;
import org.w3c.css.values.CssValue;

public class ACssPlayDuring
extends ACssProperty
implements CssOperator {
    CssValue value;
    boolean mix;
    boolean repeat;
    private URL url;
    private static CssIdent NONE = new CssIdent("none");
    private static CssIdent AUTO = new CssIdent("auto");
    private static CssIdent MIX = new CssIdent("mix");
    private static CssIdent REPEAT = new CssIdent("repeat");

    public ACssPlayDuring() {
        this.value = AUTO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ACssPlayDuring(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        int valuesNb = expression.getCount();
        if (check2 && valuesNb > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        if (val instanceof CssURL) {
            this.value = val;
            if (valuesNb == 3) {
                if (expression.getOperator() != ' ') {
                    throw new InvalidParamException("operator", Character.toString(expression.getOperator()), ac);
                }
                expression.next();
                if (expression.getOperator() != ' ') {
                    throw new InvalidParamException("operator", Character.toString(expression.getOperator()), ac);
                }
                val = expression.getValue();
                if (!val.equals(MIX) && !val.equals(REPEAT)) {
                    throw new InvalidParamException("few-value", this.getPropertyName(), ac);
                }
                if (!val.equals(MIX)) {
                    this.mix = true;
                } else {
                    this.repeat = true;
                }
                expression.next();
                val = expression.getValue();
                if (this.mix && val.equals(REPEAT)) {
                    this.repeat = true;
                } else {
                    if (!this.repeat || !val.equals(MIX)) throw new InvalidParamException("unrecognize", ac);
                    this.mix = true;
                }
            } else if (valuesNb == 2) {
                if (expression.getOperator() != ' ') {
                    throw new InvalidParamException("operator", Character.toString(expression.getOperator()), ac);
                }
                expression.next();
                val = expression.getValue();
                if (val.equals(MIX)) {
                    this.mix = true;
                } else {
                    if (!val.equals(REPEAT)) throw new InvalidParamException("unrecognize", ac);
                    this.repeat = true;
                }
            }
            expression.next();
            return;
        }
        if (val.equals(inherit)) {
            if (check2 && valuesNb > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = inherit;
            expression.next();
            return;
        }
        if (val.equals(NONE)) {
            if (check2 && valuesNb > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = NONE;
            expression.next();
            return;
        }
        if (!val.equals(AUTO)) throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        if (check2 && valuesNb > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.value = AUTO;
        expression.next();
    }

    public ACssPlayDuring(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public Object get() {
        return this.value;
    }

    public URL getValue() throws IOException {
        if (this.value == NONE || this.value == AUTO || this.value == inherit) {
            return null;
        }
        if (this.url == null) {
            this.url = new URL((String)this.value.get());
        }
        return this.url;
    }

    public boolean isMix() {
        return this.mix;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean isAuto() {
        return this.value == AUTO;
    }

    public boolean isNone() {
        return this.value == NONE;
    }

    @Override
    public boolean isSoftlyInherited() {
        return this.value.equals(inherit);
    }

    @Override
    public String toString() {
        if (this.value == NONE || this.value == AUTO || this.value == inherit) {
            return this.value.toString();
        }
        String ret = this.value.toString();
        if (this.mix) {
            ret = ret + " mix";
        }
        if (this.repeat) {
            ret = ret + " repeat";
        }
        return ret;
    }

    @Override
    public String getPropertyName() {
        return "play-during";
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((ACssStyle)style).acssPlayDuring != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((ACssStyle)style).acssPlayDuring = this;
    }

    @Override
    public boolean equals(CssProperty property) {
        return property instanceof ACssPlayDuring && this.value.equals(((ACssPlayDuring)property).value);
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ACssStyle)style).getPlayDuring();
        }
        return ((ACssStyle)style).acssPlayDuring;
    }
}

