/*
 * Decompiled with CFR 0.152.
 */
package json.text;

import json.JsonEditorPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class JsonIndentLineAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private int findPreviousBracket(IDocument document, int offset) throws BadLocationException {
        while (offset >= 0) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                if (c == '{' || c == '[') {
                    return offset;
                }
                return -1;
            }
            --offset;
        }
        return -1;
    }

    private boolean isNextBracket(IDocument document, int offset, char bracket) throws BadLocationException {
        while (offset < document.getLength()) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return c == bracket;
            }
            ++offset;
        }
        return false;
    }

    private void autoIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer(c.text);
            if (end > start) {
                buf.append(d.get(start, end - start));
                int bracketPos = this.findPreviousBracket(d, c.offset - 1);
                if (bracketPos != -1) {
                    char ch = ']';
                    if (d.getChar(bracketPos) == '{') {
                        ch = '}';
                    }
                    if (!this.isNextBracket(d, c.offset, ch)) {
                        buf.append(this.initPreferences());
                        d.replace(c.offset, 0, "\n" + d.get(start, end - start) + ch);
                    }
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private String initPreferences() {
        IPreferenceStore store = JsonEditorPlugin.getJsonPreferenceStore();
        boolean spaces = store.getBoolean("spaces_for_tabs");
        int numSpaces = store.getInt("num_spaces");
        String indent = null;
        if (spaces) {
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < numSpaces) {
                strBuf.append(" ");
                ++i;
            }
            indent = strBuf.toString();
        } else {
            indent = "\t";
        }
        return indent;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text) != -1) {
            this.autoIndentAfterNewLine(d, c);
        }
    }
}

