/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ObjectUtil;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.operation.IProjectTemplateOperation;

public abstract class AbstractProjectTemplateOperation
implements IProjectTemplateOperation {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MONITOR_TOTAL_WORK = 1000;
    private String mainTask;
    private String subTask;

    @Override
    public String getMainTask() {
        return this.mainTask;
    }

    @Override
    public String getSubTask() {
        return this.subTask;
    }

    @Override
    public void setMainTask(String mainTask) {
        this.mainTask = mainTask;
    }

    @Override
    public void setSubTask(String subTask) {
        this.subTask = subTask;
    }

    @Override
    public boolean execute(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        return this.execute(template, project, this.mainTask, this.subTask, monitor);
    }

    @Override
    public boolean execute(ProjectTemplate template, IProject project, String mainTask, IProgressMonitor monitor) throws CoreException, IOException {
        return this.execute(template, project, mainTask, this.subTask, monitor);
    }

    @Override
    public boolean execute(ProjectTemplate template, IProject project, String mainTask, String subTask, IProgressMonitor monitor) throws CoreException, IOException {
        Assert.notNull((Object)mainTask);
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        IProgressMonitor subMonitor = this.createSubMonitor(monitor, 1000);
        try {
            subMonitor.beginTask(mainTask, 1000);
            if (subTask != null) {
                subMonitor.subTask(subTask);
            }
            boolean bl = this.operation(template, project, subMonitor);
            return bl;
        }
        finally {
            subMonitor.done();
        }
    }

    public abstract boolean operation(ProjectTemplate var1, IProject var2, IProgressMonitor var3) throws CoreException, IOException;

    protected IProgressMonitor createSubMonitor(IProgressMonitor parent, int ticks) {
        return new SubProgressMonitor(parent, ticks, 4);
    }

    protected CoreException createCoreException(int severity, String message) {
        return this.createCoreException(severity, message, null);
    }

    protected CoreException createCoreException(int severity, String message, Throwable exception) {
        return new CoreException((IStatus)new Status(severity, "org.tizen.web.project.wizard", message, exception));
    }
}

