/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import org.tizen.common.Surrogate;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.web.zimlaunch.exception.NoConnectedDeviceException;

public class ConnectionUtil
implements ConnectionPlugin.ISelectionListener {
    private Surrogate<ConnectionPlugin> su;
    private IDevice selectedDevice;

    public void setSurrogate(Surrogate<ConnectionPlugin> su) {
        this.su = su;
    }

    private ConnectionUtil() {
    }

    public static ConnectionUtil getInstance() {
        return ConnectionUtilHolder.instance;
    }

    public IDevice getSelectedDevice() throws NoConnectedDeviceException {
        if (this.selectedDevice == null) {
            throw new NoConnectedDeviceException();
        }
        if (!DeviceUtil.isOnline((IDevice)this.selectedDevice)) {
            throw new NoConnectedDeviceException();
        }
        return this.selectedDevice;
    }

    public void setSelectedDevice(IDevice device) {
        this.selectedDevice = device;
    }

    public void addSelectionListener(ConnectionPlugin.ISelectionListener listener) {
        ConnectionPlugin plugin = (ConnectionPlugin)this.su.getAdapter();
        plugin.addSelectionListener(listener);
    }

    public void removeSelectionListener(ConnectionPlugin.ISelectionListener listener) {
        ConnectionPlugin plugin = (ConnectionPlugin)this.su.getAdapter();
        plugin.removeSelectionListener(listener);
    }

    public void selectionChanged(FileEntry selectedEntry) {
        ConnectionPlugin plugin = (ConnectionPlugin)this.su.getAdapter();
        IDevice device = plugin.getCurrentDevice();
        this.setSelectedDevice(device);
    }

    /* synthetic */ ConnectionUtil(ConnectionUtil connectionUtil) {
        this();
    }

    private static class ConnectionUtilHolder {
        private static final ConnectionUtil instance = new ConnectionUtil(null);

        private ConnectionUtilHolder() {
        }
    }
}

