/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.web.unittest.constant.WUTConstant;
import org.tizen.web.unittest.nls.NLSString;
import org.tizen.web.unittest.wizards.WUTNewPage;

public class WUTNewWizard
extends BasicNewResourceWizard {
    private static final Logger logger = LoggerFactory.getLogger(WUTNewWizard.class);
    private WUTNewPage page;

    public WUTNewWizard() {
        this.setWindowTitle(NLSString.LABEL_WUT_WIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new WUTNewPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IProject project = this.page.getSelectedProject();
        File testHtmlFile = null;
        File testFile = null;
        try {
            this.copyQUnitLib(project);
            String testFileName = this.page.getTestFileName();
            boolean isTestFileExists = project.exists(new Path("").append("webUnitTest").append("tests").append(String.valueOf(testFileName) + ".js"));
            testFile = this.createTestJSFile(project, testFileName, !isTestFileExists);
            if (!isTestFileExists) {
                testHtmlFile = this.importTestInfoIntoHtml(project, testFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error(NLSString.MSG_CAN_NOT_FOUND_QUNIT, (Throwable)e);
            DialogUtil.openMessageDialog((Shell)DialogUtil.getActiveShell(), (String)NLSString.MSG_FAIL_TO_CREATE_TEST, (String)NLSString.MSG_CAN_NOT_FOUND_QUNIT);
            return false;
        }
        catch (IOException e) {
            logger.error(NLSString.MSG_FAIL_TO_CREATE_TEST, (Throwable)e);
            DialogUtil.openMessageDialog((Shell)DialogUtil.getActiveShell(), (String)NLSString.MSG_FAIL_TO_CREATE_TEST, (String)NLSString.MSG_FAIL_TO_CREATE_TEST);
            return false;
        }
        catch (CoreException e) {
            logger.error(NLSString.MSG_FAIL_TO_CREATE_TEST, (Throwable)e);
            DialogUtil.openMessageDialog((Shell)DialogUtil.getActiveShell(), (String)NLSString.MSG_FAIL_TO_CREATE_TEST, (String)NLSString.MSG_CAN_NOT_FOUND_HEAD_TAG);
            return false;
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            logger.error(NLSString.MSG_FAIL_TO_REFRESH_PROJECT, (Throwable)e);
            return false;
        }
        try {
            if (testHtmlFile != null) {
                this.openEditor(testHtmlFile, "org.tizen.web.editor.html.HTMLEditor");
            }
            if (testFile != null) {
                this.openEditor(testFile, "org.tizen.web.editor.javascript.JavascriptEditor");
            }
        }
        catch (PartInitException e) {
            logger.error(NLSString.MSG_FAIL_TO_OPEN_EDITOR, (Throwable)e);
        }
        return true;
    }

    private File importTestInfoIntoHtml(IProject project, File testCaseFile) throws IOException, CoreException {
        File testHtmlFile = project.getFile("webUnitTest/test.html").getLocation().toFile();
        Document doc = Jsoup.parse((File)testHtmlFile, null);
        Element scriptElement = new Element(Tag.valueOf((String)"script"), "");
        String relativePath = this.getRelativePath(testHtmlFile.getPath(), testCaseFile.getPath());
        scriptElement.attr("src", relativePath);
        Element headElement = doc.head();
        if (headElement == null) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.unittest", NLSString.MSG_CAN_NOT_FOUND_HEAD_TAG));
        }
        headElement.append(scriptElement.toString());
        FileUtil.writeTextFile((File)testHtmlFile, (String)doc.outerHtml(), null);
        return testHtmlFile;
    }

    private void openEditor(File file, String editorID) throws PartInitException {
        IWorkspaceRoot workSpaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IPath path = Path.fromOSString((String)file.getAbsolutePath());
        IFile iFile = workSpaceRoot.getFileForLocation(path);
        this.selectAndReveal((IResource)iFile);
        page.openEditor((IEditorInput)new FileEditorInput(iFile), editorID);
    }

    private String getRelativePath(String base, String relative) {
        int i;
        ArrayList splitBase = new ArrayList();
        ArrayList splitRelative = new ArrayList();
        Collections.addAll(splitBase, FilenameUtil.getCanonicalFragments((String)base));
        Collections.addAll(splitRelative, FilenameUtil.getCanonicalFragments((String)relative));
        while (((String)splitBase.get(0)).equals(splitRelative.get(0))) {
            splitBase.remove(0);
            splitRelative.remove(0);
        }
        StringBuilder sb = new StringBuilder();
        if (splitBase.size() == 1) {
            sb.append(".").append("/");
        } else {
            i = 0;
            while (i < splitBase.size() - 1) {
                sb.append("..").append("/");
                ++i;
            }
        }
        i = 0;
        while (i < splitRelative.size()) {
            sb.append((String)splitRelative.get(i)).append("/");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private void copyQUnitLib(IProject project) throws FileNotFoundException, IOException {
        if (!project.exists((IPath)new Path("webUnitTest/test.html"))) {
            FileUtil.copyTo((String)WUTConstant.TEST_HTML_INSTALL_PATH, (String)project.getLocation().append("webUnitTest/test.html").toOSString());
        }
        if (!project.exists((IPath)new Path("webUnitTest/qunit/qunit.js"))) {
            FileUtil.copyTo((String)WUTConstant.QUNIT_JS_INSTALL_PATH, (String)project.getLocation().append("webUnitTest/qunit/qunit.js").toOSString());
        }
        if (!project.exists((IPath)new Path("webUnitTest/qunit/qunit-reporter.js"))) {
            FileUtil.copyTo((String)WUTConstant.QUNIT_REPORTER_INSTALL_PATH, (String)project.getLocation().append("webUnitTest/qunit/qunit-reporter.js").toOSString());
        }
        if (!project.exists((IPath)new Path("webUnitTest/css/style.css"))) {
            FileUtil.copyTo((String)WUTConstant.STYLE_CSS_INSTALL_PATH, (String)project.getLocation().append("webUnitTest/css/style.css").toOSString());
        }
    }

    private File createTestJSFile(IProject project, String testFileName, boolean create) throws IOException {
        String testFolderPath = project.getLocation().append("webUnitTest").append("tests").toOSString();
        if (create) {
            FileUtil.createDirectory((String)testFolderPath);
        }
        File testFile = new File(String.valueOf(testFolderPath) + "/" + testFileName + ".js");
        this.writeTestStubs(testFile, this.page.getCheckedMethodList(), this.page.isSetupChecked(), this.page.isTeardownChecked(), create);
        return testFile;
    }

    private void writeTestStubs(File file, List<String> methodList, boolean setup, boolean teardown, boolean create) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (create) {
            if (setup || teardown) {
                sb.append("module(\"").append(this.getFileName(file)).append("\", {\n");
                if (setup) {
                    sb.append("\tsetup: function() {\n\t\t").append("// TODO Auto-generated method stub").append("\n\t}");
                }
                if (setup && teardown) {
                    sb.append(", ");
                } else if (setup) {
                    sb.append("\n");
                } else {
                    sb.append("\t");
                }
                if (teardown) {
                    sb.append("teardown: function() {\n\t\t").append("// TODO Auto-generated method stub").append("\n\t}\n");
                }
                sb.append("});\n");
            } else {
                sb.append("module(\"").append(this.getFileName(file)).append("\");");
            }
        }
        if (methodList.size() == 0) {
            sb.append("\ntest(\"test\", function(){\n").append("\tok(false, \"Not implemented\");\n").append("});");
        } else {
            for (String method : methodList) {
                sb.append("\ntest(\"").append(method).append(" test\", function() {\n").append("\tok(false, \"Not implemented\");\n").append("});");
            }
        }
        if (create) {
            FileUtil.createTextFile((File)file, (String)sb.toString(), null);
        } else {
            FileUtil.appendTextFile((File)file, (String)sb.toString(), null);
        }
    }

    private String getFileName(File file) {
        return FileUtil.getFileNameWithoutExtension((String)file.getName());
    }
}

