/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.aural;

import java.util.Enumeration;
import java.util.Vector;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.aural.ACssProperty;
import org.w3c.css.properties.aural.ACssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;

public class ACssVoiceFamily
extends ACssProperty
implements CssOperator {
    Vector family_name = new Vector();
    boolean inheritValue;
    static String[] genericFamily = new String[]{"male", "female", "child"};
    static int[] genericFamilyHash = new int[genericFamily.length];
    boolean withSpace = false;

    public ACssVoiceFamily() {
    }

    public ACssVoiceFamily(ApplContext ac, CssExpression value, boolean check2) throws InvalidParamException {
        boolean family = true;
        CssValue val = value.getValue();
        this.setByUser();
        if (val.equals(inherit)) {
            if (value.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.inheritValue = true;
            return;
        }
        while (family) {
            val = value.getValue();
            char op = value.getOperator();
            if (op != ',' && op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            if (val != null && val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (val instanceof CssString) {
                String familyName = null;
                if (op == ',') {
                    familyName = ACssVoiceFamily.trimToOneSpace(val.toString());
                    value.next();
                } else {
                    familyName = ACssVoiceFamily.trimToOneSpace(val.toString());
                    family = false;
                    value.next();
                }
                if (familyName.length() > 2) {
                    String tmp = familyName.substring(1, familyName.length() - 1);
                    for (int i = 0; i < genericFamily.length; ++i) {
                        if (!genericFamily[i].equals(tmp)) continue;
                        throw new InvalidParamException("generic-family.quote", genericFamily[i], this.getPropertyName(), ac);
                    }
                }
                this.family_name.addElement(familyName);
                continue;
            }
            if (val instanceof CssIdent) {
                if (op == ',') {
                    this.family_name.addElement(val.toString());
                    value.next();
                    continue;
                }
                CssValue next = value.getNextValue();
                if (next != null && next instanceof CssIdent) {
                    CssIdent New = new CssIdent(val.get() + " " + next.get());
                    this.withSpace = true;
                    value.remove();
                    op = value.getOperator();
                    value.remove();
                    value.insert(New);
                    value.setCurrentOperator(op);
                    continue;
                }
                this.family_name.addElement(val.toString());
                value.next();
                family = false;
                continue;
            }
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
    }

    public ACssVoiceFamily(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Enumeration elements() {
        return this.family_name.elements();
    }

    public int size() {
        return this.family_name.size();
    }

    @Override
    public Object get() {
        if (this.family_name.size() == 0) {
            return null;
        }
        return this.family_name.firstElement();
    }

    @Override
    public boolean isSoftlyInherited() {
        return this.inheritValue;
    }

    @Override
    public String toString() {
        if (this.inheritValue) {
            return inherit.toString();
        }
        String r = "";
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            r = r + ", " + e.nextElement().toString();
        }
        if (r.length() < 3) {
            return null;
        }
        return r.substring(2);
    }

    @Override
    public String getPropertyName() {
        return "voice-family";
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((ACssStyle)style).acssVoiceFamily != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((ACssStyle)style).acssVoiceFamily = this;
    }

    @Override
    public boolean equals(CssProperty property) {
        return false;
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ACssStyle)style).getVoiceFamily();
        }
        return ((ACssStyle)style).acssVoiceFamily;
    }

    private static String trimToOneSpace(String name) {
        int count = name.length();
        char[] dst = new char[count];
        char[] src = new char[count];
        int index = -1;
        name.getChars(0, count, src, 0);
        for (int i = 0; i < count; ++i) {
            if (i != 0 && Util.isWhiteSpace(src[i]) && (!Util.isWhiteSpace(src[i]) || Util.isWhiteSpace(dst[index]))) continue;
            dst[++index] = src[i];
        }
        return new String(dst, 0, index + 1);
    }

    public boolean containsGenericFamily() {
        if (this.family_name.size() == 0) {
            return true;
        }
        Enumeration e = this.family_name.elements();
        while (e.hasMoreElements()) {
            int hash = ((String)e.nextElement()).toLowerCase().hashCode();
            for (int i = 0; i < genericFamilyHash.length; ++i) {
                if (hash != genericFamilyHash[i]) continue;
                return true;
            }
        }
        return false;
    }

    static {
        for (int i = 0; i < genericFamily.length; ++i) {
            ACssVoiceFamily.genericFamilyHash[i] = genericFamily[i].hashCode();
        }
    }
}

